# coding=utf-8
import base64
from Crypto.PublicKey import RSA
from Crypto.Signature import PKCS1_v1_5
from Crypto.Hash import SHA256


def get_signature(data, key):
    pkey = RSA.importKey(key)
    hash_obj = SHA256.new(data.encode('utf-8'))
    signer = PKCS1_v1_5.new(pkey)
    signature = signer.sign(hash_obj)
    return base64.b64encode(signature).decode()


def join_parameters(data):
    keys = list(data.keys())
    keys.sort()
    out = []
    for k in keys:
        if _join_parameters(data[k]):
            out.append(str(k) + '=' + str(data[k]).replace("'", '"').replace(", ", ",").replace(": ", ":"))
    result = '&'.join(out)
    print("sign_data_str=", result)
    return result


def _join_parameters(data):
    if isinstance(data, (list, tuple)):
        out = ''
        for d in data:
            out += _join_parameters(d)
        return out
    elif isinstance(data, dict):
        out = ''
        for k in data:
            out += _join_parameters(data[k])
        return out
    elif data is None:
        return None
    else:
        return str(data)
