# coding=utf-8
import random
import string
import time

import requests

import constant
import sign_util


def get_trade_id():
    return time.strftime('%Y%m%d%M%H%S') + str(random.randint(0, 999999)).zfill(6)


def get_nonce():
    nonce = ''.join(random.sample(string.ascii_letters + string.digits, 10))
    return nonce


def get_headers():
    return {
        constant.HEADER_API_KEY: constant.API_KEY,
        constant.HEADER_NONCE: get_nonce(),
        constant.HEADER_TIMESTAMP: str(int(time.time())),
        constant.HEADER_VERSION: '1.0',
        constant.HEADER_LANGUAGE: constant.LANGUAGE_EN
    }


def join_header_and_data(d1: dict, d2: dict):
    ele = d1.copy()
    ele.update(d2)
    return ele


def do_request(uri, request_body):
    url = constant.BASE_URL + uri
    header = get_headers()
    sign_params = join_header_and_data(header, request_body)
    header[constant.HEADER_SIGNATURE] = sign_util.get_signature(sign_util.join_parameters(sign_params),
                                                                constant.PRIVATE_KEY)
    print(url)
    print(header)
    print(request_body)
    res = requests.post(url=url, headers=header, json=request_body)
    print(res)
    print(res.text)
    return res.json()
