# coding=utf-8

import datetime
import constant
import request_util


# 2.1.1 Card Application (Express mode)
def card_apply_quick(card_type_id, email, mobile, mobile_code):
    uri = '/openapi/card/apply/quick'
    data = {
        "card_type_id": card_type_id,
        "mobile_code": mobile_code,
        "email": email,
        "first_name": "Xu",
        "last_name": "Changshuai",
        "user_ip": "192.168.1.3",
        "mobile": mobile
    }
    return request_util.do_request(uri, data)


# 2.1.2 Card Application (Basic mode)
def card_apply_basic():
    uri = '/openapi/card/apply'
    data = {
        "address": "asdatdfdf",
        "state": "beijing",
        "zip_code": 100100,
        "birthday": "1990-01-01",
        "card_type_id": "88990003",
        "city": "beijing",
        "country_code": "AUS",
        "doc_no": 12345678,
        "doc_type": 1,
        "email": "19413sdre10@legend.tech",
        "emergency_contact": "John",
        "first_name": "pan",
        "gender": 1,
        "last_name": "gao",
        "mobile": 1880200090,
        "mobile_code": 61,
        "nationality_code": 1,
        "sign_img": "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",
        "back_doc": "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",
        "front_doc": "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",
        "mix_doc": "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"
    }
    return request_util.do_request(uri, data)


# 2.1.3 Activation
def activation(card_id):
    uri = '/openapi/card/active'
    data = {
        "card_id": card_id,
        "file": "asddfasf"
    }
    return request_util.do_request(uri, data)


# 2.1.4 Recharge
def card_recharge(mc_trade_no, card_id):
    uri = '/openapi/card/recharge'
    data = {
        "card_id": card_id,
        "mc_trade_no": mc_trade_no,
        "pay_coin": "usdt",
        "recharge_amount": "10",
        "remark": "testing"
    }
    return request_util.do_request(uri, data)


# 2.1.5 Inquiry Card Application Result
def card_result(card_type_id, email, mobile, mobile_code):
    uri = '/openapi/card/apply/result'
    data = {
        "card_type_id": card_type_id,
        "email": email,
        "mobile": mobile,
        "mobile_code": mobile_code
    }
    return request_util.do_request(uri, data)


# 2.1.6 Balance Inquiry
def card_balance(card_id):
    uri = '/openapi/card/balance'
    data = {
        "card_id": card_id,
    }
    return request_util.do_request(uri, data)


# 2.1.7 Inquiry on bank card detail
def card_bank_details(card_id):
    uri = '/openapi/card/bank/details'
    data = {
        "card_id": card_id,
        "pub_key": constant.PUBLIC_KEY
    }
    return request_util.do_request(uri, data)


# 2.1.8 Inquiry on Merchant Account Balance
def merchant_balance(coin):
    uri = '/openapi/card/merchant/balance'
    data = {
    }
    if coin != "" and coin is not None:
        data["coin"] = coin
    return request_util.do_request(uri, data)


# 2.1.9 Inquiry on statement
def card_transaction_record(card_id):
    uri = '/openapi/card/transaction/record'
    data = {
        "card_id": card_id,
        "end_time": "012023",
        "start_time": "122022"
    }
    return request_util.do_request(uri, data)


# 2.1.10 Proceed Card Application Payment
def card_pay():
    uri = '/openapi/card/pay'
    data = {
        "card_type_id": "60000001",
        "email": "2759476460@legend.tech",
        "mobile": "18867758940",
        "mobile_code": "86"
    }
    return request_util.do_request(uri, data)


def estimation_crypto():
    uri = '/openapi/card/estimation/crypto'
    data = {
        "card_type_id": "60000001",
        "pay_coin": "usdt",
        "recharge_amount": "10000000"
    }
    return request_util.do_request(uri, data)


# 2.1.12 Card operation request
def operation(card_id, request_number, type=1):
    uri = '/openapi/card/operation'
    data = {
        # "address": {
        #     "address": "songjiangq",
        #     "city": "shanghaishi",
        #     "country_code": "CHN",
        #     "mobile": "18616781465",
        #     "mobile_code": "86",
        #     "state": "shanghai",
        #     "zip_code": "200120"
        # },
        "address": None,
        "card_id": card_id,
        "sign_img": "",
        "request_number": request_number,
        "type": type
    }
    return request_util.do_request(uri, data)


# 2.1.13 Enquiry on card operation request
def operation_result(card_id, request_number, type=1):
    uri = '/openapi/card/operation/result'
    data = {
        "card_id": card_id,
        "request_number": request_number,
        "type": type
    }
    return request_util.do_request(uri, data)


# 2.1.14 Retrive merchant card list
def card_list():
    uri = '/openapi/card/list'
    data = {
    }
    return request_util.do_request(uri, data)


# 2.1.15 Estimate the amount to receive
def estimation_currency():
    uri = '/openapi/card/estimation/currency'
    data = {
        "card_type_id": "40000002",
        "coin_amount": "188",
        "pay_coin": "usdt"
    }
    return request_util.do_request(uri, data)


# 2.1.16 Merchant transactions
def merchant_transactions(start_time, end_time, coin=None):
    uri = '/openapi/card/merchant/transactions'
    data = {
        "coin": coin,
        "end_time": end_time,
        "page": "1",
        "size": "200",
        "start_time": start_time,
    }
    return request_util.do_request(uri, data)


# 2.1.17 Modify Card Limit
def card_limit(card_id):
    uri = '/openapi/card/limit'
    data = {
        "card_id": card_id,
        "max_amount_daily": "8888",
        "max_amount_monthly": "88888",
        "max_amount_single": "888"
    }
    return request_util.do_request(uri, data)


# 2.1.18 Enquiry on card limit
def card_limit_result(card_id):
    uri = '/openapi/card/limit/result'
    data = {
        "card_id": card_id
    }
    return request_util.do_request(uri, data)


# 2.1.19 Card transactions
def card_transactions(start_time, end_time):
    uri = '/openapi/card/transactions'
    data = {
        "end_time": end_time,
        "page": 1,
        "size": 200,
        "start_time": start_time
    }
    return request_util.do_request(uri, data)


# 2.1.20 Card Application (Express mode)-v2
def card_apply_quick_v2():
    uri = '/v2/openapi/card/apply/quick'
    data = {
        "card_type_id": "60000001",
        "mobile_code": "86",
        "email": "2759476460@legend.tech",
        "first_name": "Xu",
        "last_name": "Changshuai",
        "user_ip": "192.168.1.3",
        "mobile": "18867758940",
        "first_recharge_amount": "10"
    }
    return request_util.do_request(uri, data)


# 2.1.21 Card Application (Basic mode)-v2
def card_apply_basic_v2():
    uri = '/v2/openapi/card/apply'
    data = {
        "address": "asdatdfdf",
        "state": "beijing",
        "zip_code": 100100,
        "birthday": "1990-01-01",
        "card_type_id": "88990003",
        "city": "beijing",
        "country_code": "AUS",
        "doc_no": 12345678,
        "doc_type": 1,
        "email": "19413sdre10@legend.tech",
        "emergency_contact": "John",
        "first_name": "pan",
        "gender": 1,
        "last_name": "gao",
        "mobile": 1880200090,
        "mobile_code": 61,
        "nationality_code": 1,
        "first_recharge_amount": "10",
        "sign_img": "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",
        "back_doc": "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",
        "front_doc": "iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0CAYAAADL1t+KAAAAAXNSR0IArs4c6QAAAARzQklUCAgICHwIZIgAACAASURBVHhe7Z1Bj103GYZPVoBUqc0PqNJs2CaR2FaTiB2bZH4ASocdSCidHSuSETs2ySAhNog0GypgMRmxRQoD3SAhpYO6hTQbBBKiRFSiRUih721Pe3PnnnNsH9vns/1YGk3TObY/P5/vfY/tz/a555+kjgQBCEAAAhCAQNEEziHoRfsP4yEAAQhAAAIrAgg6HQECEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEILEDgX//6V3d6etrp97vvvruy4P3331/9bKah/98/98orr3SXL18+k2/9/+vv+velS5dWv0kQgEB9BBD0+nxKiwwQ2BTsXrjXBXxJM3uB73+/9tprnX52dnaWNIu6IQCBGQQQ9BnwyAqBfmSt0bZG2v3PtpF2KbQk8vq5evXqakS/bfRfSluwEwItEUDQW/I2bY1C4OTkpPvtb3+7Em/91qi79iRx74Ueka/d27SvVAIIeqmew+5sBHoBl3jrh9St1uFv3LixGsVfv36ddXk6BQQMEEDQDTgBE2wR0Ij7+Ph4Jd4PHz5sYgQ+1wMSdgm81uCZop9Lk/wQCCOAoIdxI1dlBCTiDx48+FzEK2te1uYouK4XeI3eSRCAQB4CCHoeztRilIBG4m+99dZqJE5KQ0Aj9zfeeGM1NU+CAATSEUDQ07GlZKMEFMym0biEvIWANitu0Lq7hP3WrVurLXIkCEAgLgEEPS5PSjNMQGviBwcHBLYZ8JHW2d98800C6gz4AhPqIYCg1+NLWjJAQKPxe/fufX4iG6DsEGDUbscXWFI+AQS9fB/SghEhv3PnztbjVIFmj4Cm42/fvs10vD3XYFEhBBD0QhyFme4ENLW+v7/PiNwdmakn+3V2tr+ZcgvGFEAAQS/ASZjoRkDHre7t7bFG7obL/FPa+nb//n1G7OY9hYFWCCDoVjyBHbMIKNhN0+uk+ggoeE5T8dwSV59vaVFcAgh6XJ6UlpmAtqBpVN5fQZq5eqrLREBirsDGmzdvZqqRaiBQHgEEvTyfYfFnBBiVt9cVtK5+9+7d1Ul0JAhA4EUCCDo9ojgCOgzm2rVrjMqL81w8g5mGj8eSkuohgKDX48smWqKpdYk5J7w14e7RRuq0OQXNMVqnL0DgUwIIOj2hGAI6qlXb0RDzYlyWxVAFQypojgSB1gkg6K33gELaz3p5IY5ayEytrR8dHbHFbSH+VGuDAIJuww9YMUJAUewanZMgMEZAkfAKmNPBNCQItEgAQW/R6wW1GTEvyFlGTFXAnISdBIHWCCDorXm8kPZqnVzr5YzMC3GYMTN1B7sC5jiMxphjMCcpAQQ9KV4KDyHAtrQQauTZJKB19UePHiHqdI1mCCDozbi6jIYi5mX4qRQrNUKXqHPRSykew845BBD0OfTIG5UAYh4VJ4V9RkCirul3TcOTIFAzAQS9Zu8W1DbEvCBnFWqqRJ0I+EKdh9lOBBB0J0w8lJqATn/TPeYkCKQkoL3qjNRTEqbsJQkg6EvSp+4VAbam0RFyEWBNPRdp6lmCAIK+BHXq/JwAYk5nyE0AUc9NnPpyEUDQc5GmnjMEdAa3jnQlQSA3AUQ9N3Hqy0EAQc9BmTrOENCBMRqdkyCwFAFEfSny1JuKAIKeiizlDhJQ8JuC4EgQWJqArmB9/Pgxh88s7Qjqj0IAQY+CkUJcCXCfuSspnstFQIfOSNRJECidAIJeugcLsp+95gU5qzFTtT9d+9RJECiZAIJesvcKs52I9sIc1pi5uqFNN7WRIFAqAQS9VM8VZve9e/dWt6eRIGCZgM59v3r1qmUTsQ0CgwQQdDpHcgJaN79y5UryeqgAAnMJKPL9yZMnBMnNBUn+RQgg6Itgb6dSrZtLzN9///12Gk1LiyagEbpG6iQIlEYAQS/NY4XZqzXJw8PDwqzG3NYJsJ7eeg8os/0Iepl+K8Jq9psX4SaM3EKAQ2foFiUSQNBL9FoBNjPVXoCTMHGUAPvT6SClEUDQS/NYIfZyTnshjsLMUQK3b9/u1JdJECiBAIJegpcKs1EBcAqE0yidBIHSCegUOY3WSRCwTgBBt+6hAuzTtrTj4+NVJPv6TwGmYyIEJgkQ9T6JiAeMEEDQjTiiJDM08j45OekePnzYKfCNLWkleQ9bQwgcHR11N27cCMlKHghkI4CgZ0NdfkUSbt1frqtPSRBoiYBuZdOBMyQIWCaAoFv2jhHbNArXXnKNyEkQaJWALm/RJS4kCFglgKBb9YwBuyTkGpHrNwkCrRPgWNjWe4D99iPo9n2U3UKtkesiFabWs6OnQuME2MZm3EGNm4egN94BNpuvaXVdc8qWMzoGBM4S0Chd29i0pk6CgDUCCLo1jyxkjwRcQs46+UIOoNpiCNy8eZPZq2K81ZahCHpb/t7aWon5tWvXOu0nJ0EAAtMEFPHOKH2aE0/kJYCg5+VtrjaJuMScKXZzrsEgwwQ4bMawcxo2DUFv2PmIecPOp+mzCTBKn42QAiITQNAjAy2lOILfSvEUdlolcOvWre7evXtWzcOuBgkg6A06XSNzXZ5CggAEwgko4v2DDz4IL4CcEIhMAEGPDNR6cVorv3jxImvm1h2FfUUQ4PS4ItzUjJEIejOu/rShGpkTzd6Y02luMgIExyVDS8EBBBD0AGilZtE+c05/K9V72G2VAMFxVj3Tnl0IeiM+V/COjnMlQQACcQlwHGxcnpQWTgBBD2dXTE5de6p1cxIEIBCfAFerxmdKiWEEEPQwbkXl2t3d5UjXojyGsaURODo66m7cuFGa2dhbGQEEvTKHbjZHV5/qJDgSBCCQjsD169d5aU6Hl5IdCSDojqBKfYyo9lI9h92lEdCedO1NJ0FgKQII+lLkM9TL2nkGyFQBgc8IsCedrrA0AQR9aQ8krP/NN9/sDg8PE9ZA0RCAQE+AaXf6wtIEEPSlPZCw/vPnz3MiXEK+FA2BdQIcBUt/WJoAgr60BxLVTzBcIrCFFnvp0qXPLX/11Ve7f//735//+y9/+cvq3x9++GH3v//9r9AW2jD70aNHnU6PI0FgCQII+hLUM9R5586d7uDgIENNVGGFwIULF1Zioh/tjQ4VFr0M/vGPf+zee++97k9/+lP317/+tfv73/9upZmm7eCQGdPuqd44BL1SF+vL/OTkpNLW0SwR0Ki7F/DLly+vRDxleuedd7pf/vKX3W9+85vuz3/+c/ff//43ZXVFlr2zs9PphYgEgSUIIOhLUM9Q57lz5zLUQhW5CUjEFeyoQ0yW3iL1+9//vvvJT37SaZr5b3/7W24UJutjHd2kW5oxCkGv0NWsn9fl1Jdffnkl4m+88UbyUXgoOV3L+6Mf/aj71a9+tZqqbzk9fvy404wJCQK5CSDouYlnqI+LWDJAzlCF1sQVCyEhLylJ3H/+85+vRu8tijv70UvqrXXZiqDX5c9VawiIK9upWoftp9XLbknX6XAjvWD+7Gc/eyGyvvR2jdlPYFzN3rXdNgTdtn+CrCMgLgjb4pkk5HoZC41OX7wBEwa89dZbK3E/PT21buos+zhgZhY+Ms8ggKDPgGc1K+e3W/XMdrs0tS6xq1XIN1v97rvvdj/84Q9Xl5n85z//KctZDtYS6e4AiUeSEEDQk2BdtlAi3Jfl71p7qWvkru2bek5r7RqxS9xrE/bnz59PNZ+/QyA6AQQ9OtLlC0TQl/fBmAV91LrWyZfeemaFlGYovve971VzgA2CbqVntWUHgl6ZvzXq0RnuJJsEbt68uRqVIuTb/VOLsCPoNj9/tVuFoFfmYfag23So1lUl5OxPdvNP6cKOoLv5mafiEkDQ4/JcvDQEfXEXvGBAawFvsemXKuwIeuyeQHkuBBB0F0oFPYOg23CW1sm1BU3r5KT5BDS7oTX2jz/+eH5hGUpA0DNApoozBBD0yjoFgr6sQ1uPXE9JX/Ehekn68Y9/bPqaV/UBHahDgkBuAgh6buKJ60PQEwMeKL6/NKW0Y1qXoTWvVonlt771rdWlMBbTrVu3VvESJAjkJoCg5yaeuD4EPTHgteIV6KYgN4k4wW75uPc16ba3b37zm93Tp0/zVz5SI5ezmHJHU8Yg6JW5G0FP41Ad5ynR7u8dR8DTcA4p9ac//Wn37W9/28Q0vLYlKpCPBIElCCDoS1BPWCeCHg+uRuAafVu4ezxeq+osSevrr7/++qK3u2nZRZ8/zhios4+V0CoEvQQvediIoHvAGni09ktS5hOyW8L3v//97gc/+EF2AxUIpzPqEfPs6KlwjQCCXll3QNDDHcpWs3B2lnJKWHd3d7NFmnP6nyXvt20Lgl6Z/xH0MIdqulRrn6yNh/GzlktT8N/5zne6t99+O5lpiqvQOQOt3JKXDCQFRyOAoEdDaaMgbem5ePGiDWMKsYK1z0IcFWCmXtK++93vdh9++GFA7hezaAZH4q0fxVW89tprs8ukAAjEJICgx6RppCxuW3N3BGLuzqrUJzUFLxF+9uxZUBNeeuml7he/+EX3jW98Iyg/mSCQiwCCnot0xnoQdDfYGnHpy56Rlhuvkp+aK+rqI9pfTtBbyb2gftsR9Ap9jKC7OfXo6Gg1dUpqg4DW1TVSPz09DWqw4it0Oh2iHoSPTBkIIOgZIOeuQqMJa6dn5WYwVR/Hc04RqvPviHqdfqVVnxJA0CvsCRqFnJycVNiyOE3SVLuCBxlpxeFZWikSdR0YdHx8HGS6ZnU0u0OCgDUCCLo1j0SwB0Efh3j79u3VrV2ktglI1B88eBAEQXnv378flJdMEEhFAEFPRXbBciVWBwcHC1pgt2qutrTrmyUsQ9SXoE6dqQgg6KnILlgugj4M/+7du6vDQEgQ6AnMEXWN0rkyl75khQCCbsUTEe14+PDh6uhL0lkCH3zwAWvndIwzBOaIOtel0qGsEEDQrXgioh0c/7odJldbRuxkFRalYLeQQDn2qFfYGQptEoJeqOPGzOb41+102HdeYWeP2KQ5W9qIfI/oCIoKJoCgB6OznZHDZc7658mTJ5wKZ7vbLm7dHFEnPmNx9zVvAIJeaRfQqVahJ2LViER7z/VlTYLAFAH1E02jh5z9znr6FF3+npIAgp6S7oJlh64HLmhy0qp3dnY6xRaQIOBCIPTsd9bTXejyTCoCCHoqsguXy9a1Fx2AoC/cIQusXqJ+5coVb8tZT/dGRoZIBBD0SCCtFaN7oPf29qyZtZg9CPpi6Iuu+N69e93+/r53G1hP90ZGhggEEPQIEC0Wwda19CN07SbQJThirdEca/QWPwnzbXrvvfe6f/zjH94Ffe1rX+t0l3qKpOOdFSejkw/1mwQBEUDQK+4HRLp/4dyYI3SJt2Y/9JsEgaUJ6JIhnVjHVcBLe2L5+hH05X2QzAKuUf0CrUYxikCemw4PD1cXuzAan0uS/LEJ6EhjXTzELYKxyZZTHoJejq+8LeXWtReRPX/+3JvhegaNyhWbQIKAVQJ6cX306BGibtVBie1C0BMDXrJ4It1fpK8vOr3kuCSNwLWPv18f/93vftf985//dMnKMxBYlID6uPo6qT0CCHrFPifS/UXnDkUeb4q31sYV8OaTFJykJQ4SBFIT6PvrWD3cApfaCzbLR9Bt+iWKVUS6v4jx1q1bq/Xv9ZF3iHj3per0OZWnm7pYt4zSZSnEg4BuVdS6uXZabCa9XOqoY1JbBBD0yv1NpPsXDv7yl7/cffTRR9E8zjGf0VBSUCCBsWNq6Z+BUAvOhqAX7DwX04l0d6Hk/4yiiTU6J0FgaQJDS2scbrO0Z/LXj6DnZ561Rs50T4PbJ8AujQWUCoFPCQxdl8xLZ3s9BEGv3OehR1dWjmV28+ZugZttAAVAYI3AtqU1BL29LoKgV+7z0AsmKscyu3ljgi7mx8fH3O42m3LbBWhPuX5u3rw5CkLr6OfPnz/zDILeXv9B0BvwOYFx8Z08JOhsFYzPuvUSp/aVD+1mYQ29vZ6DoDfgc06Mi+/kbYKutUxdt8mxsPF5t17imDgPCTpxHu31GgS9AZ9zYlx8J28TdO0L3t3djV8ZJTZPYOxyoaF+h6C3120Q9AZ8zgEz8Z28TdB5cYrPmRI/JTAm6EP9TgfLcHphWz0IQW/A30NBMw00PVkTEfRkaCl4C4EQQWcnRntdCUFvxOeKltWRp6Q4BBD0OBwpxY3A9evXO02tb0s6evjBgwdn/oSgu7Gt6SkEvSZvjrRFZz7rLm9SHAIIehyOlOJGYGwL2rag10uXLnXaPklqiwCC3oi/2U4V19EIelyelDZOwFfQx6boYV0vAQS9Xt++0LKh4yEbaX70ZiLo0ZFS4AiBMUHXoTKbWyUR9Da7E4LekN9ZR4/nbAQ9HktKmiYwtgVt28FRuipYxz6T2iKAoDfkb9bR4zkbQY/HkpKmCQwJ+tDRzhz7Os20xicQ9Bq9OtAmznWP52wEPR5LSpomMHS3OafETbNr6QkEvSVvf9JW7keP43AEPQ5HSnEjMLQFbeg2RU6Jc+Na21MIem0enWgP0+5xHI6gx+FIKW4EhgR96JQ49qC7ca3tKQS9No9OtIfzxuM4HEGPw5FSpgmMRaxv24P+8ssvc0HQNNYqn0DQq3TreKNeeeWV7tmzZw22PF6TEfR4LClpnMCYoOt2v80DZNiy1m6PQtAb9P3QUZENoghuMoIejI6MngTGtqBt27J28+bNTgdJkdojgKC35/PVh31vb6/BlsdrMoIejyUljRMY2oI2dOkSW9ba7VEIeoO+5/a1+U5H0OczpAQ3AkMR60Nb1u7fv99pFo7UHgEEvT2fr1p848aN7vj4uNHWz282gj6fISW4ERgSdLasufFr6SkEvSVvr7WVaPd5jkfQ5/EjtzuBoS1oXJvqzrCVJxH0Vjy9pZ0cMhPufAQ9nB053QlcuHCh08VK29K2CHeuTXVnW+OTCHqNXnVs09ChFI7Zm34MQW/a/dkaP7YFbVuE+/Xr1zvNvpHaJICgt+n3Vavfeeed7vXXX2+YQHjTEfRwduR0JzC0ZY1LWdwZtvQkgt6Stz9rq6JjDw4OOv0mhRFA0MO4kcuPwFDE+tDWU85w9+Nb29MIem0eHWmPpuL29/cH1+QaQjHaVB2dqbvjlT766KPuD3/4w5nnEXR6Sw4CQwI9dCfDBx980OkkSFKbBBD0Bvyufec6SIa1te3O/vWvf9299NJLnc7F3kw+l18Qk9DAhylzE4ci3Led4T4WQJfZbKpbiACCvhD4XNVKxCXmEnXSWQJT5177CDon8NHDYhIYi1jfFhA31Zdj2kZZNgkg6Db9MtsqCbjWyXX4BGmYwN27dztNXw4lH0EXc20F5OIbelwMAkNnshMQF4NunWUg6BX6VR/43d1d1sodfPvkyZOVCMcQdJWhUbpeEBB1B/g8Mkpg6GWTE+LoOEMEEPTK+obE/Nq1a0yxO/jVZc3RZ4TeVykf6Gjdp0+fOljBI74E+qBFvYjpRwGMCgTr/63yNFvSXyva/7d2dZycnPhWt9jzjx8//jw4c92Ibevn+vvQevtiDaDi7AQQ9OzI01WYWsxfffXV7qtf/Wr39a9/vfvKV76y9cumb52OpbQuaGPXUvbtCBH0XlDEgPPy4/R3rSdLyPSitC140acWxZVolGtZ3PXSMhT3wvq5j7fbehZBr8TfmurVlrRYwW/6QtEXp340AvL9Ei0hQGxoBLTeJUIFvS9jaHq0km6XtBnqgxJw+WBsWSTUCB2pquURiy9dQwFuQzescWVqaC+oKx+CXoE/Y4qnvkj0Jacv0jnJeoDY2AgopqCrLKbg/XqSfKM+qJ8ce6o1YtdsiqW4h6H186EXTA6U8etjtT6NoBfu2VhirohafYH2B6rEwDJ0G1SMsueWMRRBvFlurC9QveAwBT/tNZ1Frj6dQ8jXrdFoXS+xp6en00ZmeIL18wyQK6wCQS/YqUPbV3yapC9QTQunmtK8ePGijznZnj06OnKahRi6ZjZ0ipMo+O0u1qhcbObODM3pQHrp0tLS0qLO+vkcL7adF0Ev1P/68tH1iUNXK041K9cX6FBE7pR9qf/uekSm+A69lIROc1obDaZmPVW+At4k5qGzQ+vBbWK7/nKqJSSfpM+V7FgyoHNo9mjo5XLqLAWf9vNs2QQQ9EL9p9Pf9CUYkvQlp7wpRuWb9sRaEghp51Ae3ysmh15KNC2sKXlFy4ckjortOom5Ar18ptgVxKY8+um3po3x74M75XeXlwaVqTxLrakPzR4NLWG5BHeG9E/ylEcAQS/PZ6sz2XVwTEha4m1eLw5Ljng2OQ3dYDXEcyiyuH9e08Qq00eU+rwSD31RLz3NG9KX5ubxEXONnA8PD1fLQ3N2ckiotVwytWtjqRfRsen28+fPn2m7y1kKc/1E/nIIIOjl+GplqaYUNdUe8qXmK2Sx0FgbiU6dDret3UO3W/XPSszFN3QNeKr8WL6wUo6PmPdHGIf0+aH2StDlr7FZKvky95Y23+l2l7MUrPgcO9ITQNDTM45ag8TcZZpx7qg0ptH6ItbowkIau/Biyj6XqP05o3XNBJRwIM8Up6m/axSqF9OpGQ09o5mokP4+ZYP+rvo1vT00Wl9i6yXT7S6e45khAgh6QX0jdKS71Mh8Ha2LGOZwRWh0em+by0haoz4xn5rWHWpvqJ9z8ItRh0swYeyDksbsHvt85DwYaGj6XC8WCszcnKFguj1Gb6yrDAS9EH8OfainzF9izXybTVPr0FPtiPX3GAFEaotG4lNBUxJ/vUBMjUS3ta3WtXWXFyrX9esvfelL3ccff7zCp/vs33777dXvPolhHzw35asxUc8VAzL0WR3iwXR7rG+FespB0AvxpeuX3HpzfKO5U6NQhPGSwV8xRzSuB8VIDDSN6hJdvY2/RogasU8JUmrfxSjfZbnDpZ9rl4aYiOn6Us7Yy6vKVZ6h4Ey9dOllb9uaeq6X0aGtlEPLbDFeTmP4lTLsEEDQ7fhi1BJNufnsOXddp8zZfJcv65T2pBjRuB4bKjHR6DQkWT5z3Kc9UwI0tXtj23719aUcibECHoeSXsI0a/LgwYOtj+gFQTZuS6nPU/C9+9zl5cjHNzxbBwEEvQA/hgihyzrlEk3XSGip0abr6XC+XCQUmoKfPnUuaQAAIABJREFUur1LgqGp3dDReslBc1NT7VM3BQ69jG0e/OMSLzK2Lj5k59gBQ779ZfP5sZfvodgTl3bOtYv85RFA0Avwme/ofOrLc8kmuwSVpbDP9TKWOXW7To/3h9GErK3LPuVXXUu9GPkymlrq0AvRtWvXBqPZp8RrfXuZmGqUPsV2SCjHpt5T9d2hz+tQ3EyOvuzrY563QQBBt+GHQSt8R+cWp9rXG5dypDPmylzxBGqfxGJqtK7pYa35hu5bn5o+ttStp2aLtDVN0+3bkktQ5+Yat8sL7di57fKJZnM2U4pjYfWyo9mJbS8gQy8dKZaOLPUXbAkngKCHs8uS0/dwC5cvsyyGj1Ti26YY9k6N8mLUsV6G69YzlwNOxmyTGGjkOPUCEbt9ruVNvUiNTX+73ognW9bXuF1H6WOXGw29hEyt87ty6Z8biisYe/ENORjJ1y6eL5MAgm7cb+fOnXO20ProvG9I7C9FF0Cul7G4lOX6jM/Ws7nT8BqlqgxLwj7VH8fWzRXJrja5ps1RuusodmgaXS8IEvVtyfVlbcr2sZfvodG5z0vOVP38vT4CCLphn/pul4k9OtcXrgRCIx5F1YYGc21DnGtvr+r2FYfYXcJVAMREz+pLOzTpZUllLLk9sLd9arp8aDvW1IvAEJvNSPSpqHqVM3Ya3FgQ5dyDksaEeWzmgNF56CejjXwIumE/uwqBmhD6Jbit+fpC2d/fPzNCmjs9vF5XzhO4poQlRxfwmRoXZ9k85wVq6RH71EvUWN+eWnMf8tfmC/DYKHu9jCFbprbBhYr61ChbAYLbZiem8uXox9RhmwCCbtg/Pue2T61VujZzavuQRuv6wp0jNlMjI1dbXZ+zNKqZOuBkvU1zTprry1lC2KdeLsdmnlynyl1H6S7ljQW7TcVeyJ/yk8uOAwXA6UV2LBBy7EV3iWUj188Yz9kggKDb8MMZK3wvNIk1CnXZIuc68plCGzrCmSp3/e9TW6Z8yor1rHyrL27dIjaV9AKlZ+dMw6sOBVlpJKopeRfxmbJr7O9jI2y1XS+q2w5JinFYyraXBQmuPh9jaWg3iUbpmrof2wanNomrfrbdzqbZCom4+vtYOVMv08+fP5/jFvI2QABBN+pk38CxGKPQsbW7TUyh06Lr5fjUF+omlxFaaNlz87lucVM9MdbXVY7ER+KlnxTr7FMj2r29vVXd25LLmrcL8227KCSmEvUxQR2K6wjpQ/1WtLHrWdfbMrUXX88i6C7eb/sZBN2o/33Wz2ONQn3qDPmS24Y69ZGasUQiZTfRy5tGkUPnjK/XHUvY+1G7Rv+q36XuMQaaZldZEs6hNHamQqwZpv6lRZw2ZyK0TKQX0SFRH1sKSN2PXJbXEPSUn8I6ykbQjfrRZzo6VrCMj6CPnXvtg9T34Byfsks6UctnGj7miL3nqdmCftrYd+ubppTlx7HRaMwtai59YKhfTcWADL1guky9u9i1+Yz8rgDUoVmL/vkYyxEh9pGnLAIIulF/+YxcY41ufCPPYwXppNrCFutFJ2cX8ZmGl13qJ9quGHr3+lDbJMDrP/3IV9P0mhGSz/RSpxfPqQDJselkvXSpHtepaR9fjIm6PjPbZhPEX+3ZFmcwdIKcj03rz7pMs/fPT+0aCLWBfHURQNCN+tNH0GOsZwuD77GsU+ulrmh9ZgZcy9RzqS5j8bEh9Fnfi1jUXzRtr90O1tLYdHJqH43NAOkFVktHm2nsxVYvAer3c5P8q3gC1xsUEfS5xNvIj6Ab9bNLtHlveixBV3k+o+VYI2DfFwlXl8WaQXCtL8VzPtvcev9J2OWbqQtKUti7WeZYEFysOIypdoxdqjIk0BqlDwUNzoljUF8XE59T8NQ+BH3Ky/xdBBB0o/3A58jXmAE7Pmv3Uwdv+KD1qdel3Fj78l3qyvFMyA1rYiphjz0d79reMTHPvSY81r+2ibrLRSy9sOt3vwyxyUbl6MVA8QkScS0vhCQEPYRae3kQdKM+9xH0mNGvvkFqMbbLyQW+x9xOuS3WcsBUPTn/3gfO+V6dKsHJOWqfGoWO3TCWkqevqEt89TLks29fI3vNjIiB63S6S5sRdBdKPIOgG+wDvlPQMQV9qQNt5IaxaU5fN8V60fCtN8fzocIu2yRqEikJRIpAtMPDw9UBNrJxW1IQnF7epgLpUnAcuzJV9W1bugoR9RS2I+gpqNZXJoJu0Ke+ohpT0H2FNebUtu/swJDrck/nLtmFfNfY122VqErcFb0twQhN6q8PHjxY7UMfG5UuKeZ928YEeugERJ9b80IZTuWL+Tmbqou/l0sAQTfqO58p99jBX2NBRJu4NL2o+mOksZuvfMqPfeucT91LPduf/ua7h3zdXgl7P2Xcj6D1crQtuE71SOg02tbP0Ii8L9+CmPe2jEWxjwWYKp9mH3ym4If6g3iIsau/WuzTS32WSq4XQTfqPR9BjxnlLhy+x87GrN/nZWLIdTGDBI12j0GzJLISHo2YYyZNz4euCeulQC8cS0yzDzEY2s0xdWBSf267GPsenSsR72dE9PLkep6/2oCgx+zN9ZaFoBv17RL70NdR+LxQxPyy8Y0f2HRfrGNwjXYLZ7PmCI9zJQ4P5tqa5mDKC4+MLe+4LmGJcT9LocI3t6LppaH/0YvC5gvNtjPnh9oR8zPmy4rnyyGAoBv1lY+gp4jo9qk/dsCOT92b7rMqIEt2M70kxTqz3bUderGSaC61Zc7FzqGX1lwBlT79PNZpkC5ceKZcAgi6Ud8t/fa+1DGwcofvlP+6C1OfPGa0uzib1Z/Znuq2Nb3cadlk7M5vZ2MTPzgkqDGXkMaa4HIhS58/l02JkVN8YgIIemLAocX7HIeaIgLW92rT2F84PifW9YxLuowltF/EzKcp4/6wE/12DdDatEEi3q8NW1onn2I1JOi5prd9lrVif76m2PD3Mgkg6Eb95iPoMSPN13GoXNeI3thfOL4zBLI7xYuN0e6RzKz+QBS90PWR6/1/qz+sC7YE0fKU+hSk8+fPb43OzzW97SPosXeyTLHh72USQNCN+s132jm2oAqLz7R/7MjykC1sKRgY7R6YNZPA2AxUjn7kOwPmGqg3EwvZCyeAoBt2oM8bfIpgMNfjWFNFlutLT+uxU1PB2halE9D0LAkCLgTGZoBiv5xus8f1s6W8LCW5eJRnRABBN9wPfEbIU/tnQ5vpEombIso+1F7yQWCKgGZ/FJC2bV99LvH0mYGLvYtkig9/L5cAgm7Yd77ryCm220ydf50rgMiwmzCtMAK7u7urnRTbUq44DJ8YGQS9sA62oLkI+oLwp6r2PWQl1v3km3ZJ1PujRfvTsfTFpynukoOipvjz9/oITI2Mc6yfi6qPoKdYTqvPs7SIKfcC+oDv9q0Uo/QCMGEiBCYJ6KV0f39/8Nz5nCNhn+U0ZsEmXcsDnxFghG68K/iebZ5qlG4cE+ZBYJCAZpgk5BL0oZT78hifQ2UQdDq3KwEE3ZXUQs/5RMP2JjJKX8hZVGuOgD4/EnPtmBhLuQM7fXaw5FoGMOc8DPImgKB7I8ufwSXSfN0qTefpCFQSBFol0N/PPiXk4pNbzH33oPOC3mov9m83gu7PLHuOkFF6rtOussOgQggMEJBQSsgV+OZy1aum2fVs7sDOqcC89ebl2kZHp6qDAIJeiB99R+lqFlN1hTgXM4MISMB16JBeePXTH1XrUpgixxVpruNscyefCPecgXq5OVBffAIIenymSUoMGaXry0rTdUt8aSWBQKFNEtCoW+LdT59v3jvuCkWjXS1HKdB0yUtkfCLc2bLm6l2eEwEEvaB+EDJKVx6N1EkQKJGA71kM29qoMxP0OdDxwBZebn0i3Fk6K7HXLmczgr4ce++aQ0bpqkRfZAr8IUGgNAK+l/RoilpnN+jH6m1wRLiX1gvLsRdBL8dXK0t9puvWm6Z8EnULI5TCkGPuwgQk6uvR6vrvzSnzXsQXNnWyet8Id65NnUTKA2sEEPTCusPU2epjzdGXoKbfEfXCnI651RAgwr0aV5psCIJu0i3jRuktX9OJz54987YeUfdGRgYIRCNAhHs0lBS0hQCCXmi30DGWe3t7QdZrhK7pd03DkyAAgXwEfAJbiXDP55daakLQC/ak7znvm03Vl4uEXeuPJAhAID0Bn4A4ItzT+6O2GhD0wj2qKfT+StOQpmi0rhcDXQBBggAE0hHw3aXy+PHjRffLpyNByakIIOipyGYq13dbz5BZGqVL2LVnlxF7JudRTVME7t27t7ooxiVx5KsLJZ7ZJICgV9AnFCSnveZzRurrGLS2rh9dxUqCAATiEPDZcsqRr3GYt1YKgl6Jx+dsZxtCoOl4Telrrb3f56svGhIEIOBP4Pz5887nzXMHuj9fcnD0a1V9IIWobwMkke+FnlF8VV2IxiQi4HugDBcrJXJE5cUyQq/QwZp+14UWOZJG7vryYd09B23qKJWAz/q52vj8+fNSm4rdCxJA0BeEn7LqnKKu0boickkQgMB2Aqyf0zNyEEDQc1BeqA4dPqPI9ZAT5XxN1n52vUSQIACBswQuXrzY6eY4l8T6uQslntlGAEGvvF9oXV2innoKXtvddE41CQIQeJGA7xWwrJ/Tg0IJIOih5ArLp0MtJOyxtrZtaz43QxXWKTA3CwHWz7NgppJPCCDojXUDXQ6hL5gU0/BMuzfWmWiuE4ErV668cP3rWKZLly45P+tUOQ81RQBBb8rdnzZWU4BaX9fP06dPoxFg2j0aSgqqhIDvdDsXslTi+IWagaAvBN5KtZqKl7Br/XvuqF0H0WjanQQBCHxKwHe6nfPb6TlzCCDoc+hVlFfBcxJ1ifvJyUlwy46OjriWNZgeGWsj4DPdfuHCBedI+No40Z44BBD0OByrK0UnW2m6UL8PDg6c26eT4/RSQIJA6wSYbm+9B+RvP4Ken3lxNfociqET4548eVJcGzEYArEJ6MV2b2/PuVi2qzmj4sEBAgg6XWOSgO8XE+uAk0iLeqA/ECX28b6a/VGZir2oMfm8CHNdao09IH+bEPT8zIurkanD4lw2y2DFU+jebgmuftaTBFi372lpRb9dk8o8Pj5exWkoEFP/7lN/q59OGqzlsh+1T7eruSaWqlxJ8dwYAQSd/uFEQOe1ux5KQ7S7E1JzD0mEDg8PV5HZ64I7ZKjEXYcVaavVUOpfDiTkrmXevXu3+MBK31ktgknNfRyKNAhBL9Jt+Y323X7DITP5fTSnRonttWvXgg41kbDL3+sjdt+Xg03bS+8/TLfP6Y3kDSWAoIeSayyf77Q7h8yU00HmiPl6KyXoGmlqml7BYK6XkQyRKlXUfT8rTLeX81mxbimCbt1DhuzzmXaX2Yp2jx1IZQhHNaZo2lxT7TGSlltcptZd6yox8tuXJ9Ptrr2B56YIIOhThPj75wR81wW1FqovN5JdAr6jydwt0Uukdk2UlBQM5/NS8/z585Kah62GCSDohp1jzTTfyF32pFvz4Fl7tG6uqHPLqaSpd9+XXqbbLfe88mxD0Mvz2aIWa2uRz93q7Elf1F2jlWutW0eTWk8l7ZrwOepV3EtcUrDeX1q2D0Fv2fsBbdf2o93dXeecjECcUWV/0HetN7uBaxWWIHy+L0hclbpkj6qzbgS9Tr8mbZWm0n2uXSU4Lqk7ggu/ePHi7Ej04Mo9M5Zwrajv7FVJSwme7uLxhQgg6AuBL7naO3fueF3YUsKXccn+CLHddzQZUkfMPNbjMRRfohck12A4HfWqgMRaj72N6XvKcieAoLuz4snPCPhGRutLS6N0vrzsdCEFwikgrqRkORrc9+AllqJK6nnl2Iqgl+MrU5bqEBGfe9Nv377daWRPskEAQY/rB9/lC5ah4vKntE8JIOj0hCACvoJgfco0CELBmXz9Z6GpVkfovlvVdnZ2zG8VtOBvbPAngKD7MyPHZwR8g+MIArLTdUoTdMvXi/qOzvkc2Pkc1GYJgl6bRzO2x3dkwig9o3Mcqjp37pzDUzYesXo3gO9n4MKFC8XsLLDheazwIYCg+9Di2TMEGKWX2yl8bgRbupUWjxFWRLsOkvG5hIZYkqV7Ut31I+h1+zd563y3sDFKT+4S5wp8I7OdC07woMUgMt++LywW25HAXRS5EAEEfSHwtVSrUYpE+tmzZ85Nsjjacja+sgd9Z1iWaL7Fcwx8952LG6PzJXpPW3Ui6G35O0lrfY8QZV96EjcEFep7lG9QJTMyWT2AxXd0brUdM1xDVoMEEHSDTinNJN+DZhit2PKw75kCOa23OJvD6DxnD6AuHwIIug8tnh0k4HuOtUbpuolNU76kZQlIoCTqp6enyxqyUbvV09QYnZvqJhizRgBBpztEIRCylm71CzsKkMIKCfFfyiZa7RuajVJku+uZ7cxGpewllL1JAEGnT0Qj4DtyUcUlXIsZDZDxgnRhi0bqPgGOKZqka0V18I3Fs/91/r1sc03ady6uFtvi2gaeK4cAgl6Or8xbGjLKu3z58mrqnWSDgMRHyydLTb9rZK7tdBYFMGSbH6fC2ejXrViBoLfi6Uzt9D05iynJTI7xqEYvZhL14+Njj1zzH7UYANe3KiQQjlPh5vcJSvAjgKD78eJpBwIhe5s1StdonWSHQMgSSoj12tKl7XOa7readnd3Vzb6JEbnPrR4NgYBBD0GRcp4gUDIxR/6Mtd6OskWAflSo/WnT58mMUxntGsq2/Juh5C9+ozOk3QXCp0ggKDTRZIQCNnbbHnKNQmkQgrVdLNE9+DgIJrFEjyVqfPkLaeQqXa1h2BPy16t1zYEvV7fLtoyBVdpe49PYm+6D638z2rLlkbrJycnsyrXUa6azrcY+LbZsJCpdotH1c5yGJmLIYCgF+Oq8gwNWYMl6t2+nxX4KN/6TsPv7Ox0ymt5en2dfsjSEdvU7Pffmi1E0Gv2roG2SaB9t0AxwjHgOAcTXIVdQq4XAMtBb5vNDZ1qPzo6Mr+M4OBaHimUAIJeqONKMTtklKO28cVYioe71ah724i9RCHvqWu5SMtGPkkBfr6R8D7l8ywEpggg6FOE+PtsAr63salC1tNnY89egIRd6+xKCnYrdRvi3t7e6iXFJ3Gbmg8tnk1FAEFPRZZyPyeg6Ut9ufuuubKeTifKTSDkYCRmlHJ7ifqGCCDo9I0sBEKn3llPz+IeKvmEQMjODIFjqp3uY4UAgm7FEw3Y4XvFao+EE7ca6BwLNzHkFjWZrKl2vQiUErm/MGaqT0wAQU8MmOK/IDDn3m2C5OhJqQioX+oWNd8gONnDYUipvEK5IQQQ9BBq5AkmoJGQ1sZ9r+hUkJxO3yo10CoYGBmTEwgJgpNRVu9sTw6MCswSQNDNuqZew0LOxhYNRL3ePrFUy0KuRJWturM9ZES/VDuptw0CCHobfjbXypCtbGqERugaqZdwbKg56Bj0AoHQiHa2qNGRrBJA0K16pgG7Qk6RQ9Qb6BgZmhgq5jKNq34zOIgqgggg6EHYyBSDQOh6OqIeg367ZcwRc3ZctNtvSmg5gl6Clyq2MXR/OqJecadI2LQ5Yk4QXELHUHQUAgh6FIwUMofAnC9Z1tTnkG8r75x+RhBcW32l1NYi6KV6rjK7Q6ONGalX1hESNWeOmHMlaiKnUGx0Agh6dKQUGEog9CQ5RD2UeBv55oi5Itq1LMT5B230ldJbiaCX7sHK7J8j6uxTr6wzRGjOHDFX9QTBRXACRWQjgKBnQ01FLgTmHA+r8iXqOo5TLwaktgkcHBys7mkPTYh5KDnyLUUAQV+KPPUOEpgr6ipYB9dI2EntEVD/2d3dXU2VhybEPJQc+ZYkgKAvSZ+6k4r61atXO13qwqly7XQ0ibjEXKIemhDzUHLkW5oAgr60B6g/qajrWkuJOkFN9Xe0uVPsIoSY199Pam4hgl6zdytoW4zpd9bVK+gII02IMcWOmNfdR1ppHYLeiqcLbqe+sG/cuNGdnJzMaoXK0AiMKfhZGE1ljjHFjpibcinGzCCAoM+AR9a8BOZsaestlZhL1CXupLIJxJhiR8zL7gNY/yIBBJ0eURSBGKKuBkvQFQWvNXZSWQR0D/n+/v6sKPa+xayZl+V7rB0ngKDTQ4ojMOeY2PXGarSufcq3bt0qjkGLBmvpRUKuw2LmJp0A9/Dhw047IUgQqIUAgl6LJxtrh9ZONcp+9uzZ7JbrS10jNUbrs1EmK0DT63qRm7MdrTdOZ7NLzNn5kMxdFLwQAQR9IfBUO5+A7lOXqJ+ens4v7JMSNJ1/+/ZthD0KzTiFSHg1KpevY6Tr16+vRvgERsagSRnWCCDo1jyCPV4ENGKTEB8fH3vlG3sYYY+GMrigmOvkvRGKmdAJgiQI1EoAQa/Vs421S2vhmpaNlTSC05e/1tcZzcWiOl2ORuLyY4x18r42ptinufNEHQQQ9Dr8SCs+IaDpWY2uY6yr90B7Yb958yZT8Ql7mWIiDg8PVz6MmZhij0mTsqwTQNCtewj7vAikmILvDdB6vV4YJBKk+QTkqwcPHqyC3WKtka9bxRT7fB9RQlkEEPSy/IW1jgRSjNb7qhUNr+l4jdqZjnd0yNpjWh/XaDzmtPq6FdqSphE/Uez+viFH2QQQ9LL9h/UjBFKO1vtqNWLXyJ1R+3hXlC8UuKjRuAQ9VWKKPRVZyi2BAIJegpewcRaBlKP13jCN1CXs2tMuUWHk3q2m0XX+vvhrxBxjD/lQR7h06dLqZYGDYmZ9VMhcOAEEvXAHYr4bAYmJpsm1ZpsjSVj6kXsrB9aIsQRc4i0RT7Euvuk7Ta9LyDVTQoJA6wQQ9NZ7QGPtl9hoi9vcm9t8sEnQJe5a09VIsqa1XU2faypdXPWTM+kQIL2kMRuSkzp1WSaAoFv2DrYlIyDxkRjEOmXO11CN4CXs+i2Rtz6K12j76dOnq/Vv/bd+6yflNPoQUy1paFRunZlvn+B5CMwlgKDPJUj+ogko0lojdonVkkmjTAl8/1u29OvBOzs72UzTzIVEel2wc4+8hxrLOnm2bkBFhRJA0At1HGbHJWBF2Mda1Qt+/8xQAJheCjR63Ywm74V6sw4rgj3Udp30ppcu1snj9nlKq48Agl6fT2nRDAKaytXP0iP2GU2oJqtmJiTiCHk1LqUhiQkg6IkBU3yZBBSlrVF7zEtfyiSR12pFrUvAFd/AGnle9tRWPgEEvXwf0oKEBBQAJmHXD6P2dKC1Pi4R124AotbTcabkugkg6HX7l9ZFJNALe84tbxHNN1mUjs+VkNe0lc8kaIxqggCC3oSbaWRMAhq191PyS217i9me3GVpbby/6IbReG761FczAQS9Zu/StuQEFDkuce+PN415dWty4zNVoCj1/uQ8/UbEM4GnmuYIIOjNuZwGpyTQC7t+t7rmrsA2CXcv4gS3pexxlA2BLwgg6PQGCCQioKl57fHuD2mpee1dQW3ro/BESCkWAhAYIYCg0z0gkJFAL+76LbEvbQ2+P6ZWQWz9QTfccJaxA1EVBBB0+gAE7BLoT2rrz0bvf/fnp+e2XFPmm4KtaXOmznN7gvog4EeAEbofL56GQHYCEvb+KtKhC1GGjnWVsdtG0JvHyOq5bf8ve2OpEAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQAACEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE0DQg9GREQIQgAAEIGCHAIJuxxdYAgEIQAACEAgmgKAHoyMjBCAAAQhAwA4BBN2OL7AEAhCAAAQgEEwAQQ9GR0YIQAACEICAHQIIuh1fYAkEIAABCEAgmACCHoyOjBCAAAQgAAE7BBB0O77AEghAAAIQgEAwAQQ9GB0ZIQABCEAAAnYIIOh2fIElEIAABCAAgWACCHowOjJCAAIQgAAE7BBA0O34AksgAAEIQAACwQQQ9GB0ZIQABCAAAQjYIYCg2/EFlkAAAhCAAASCCSDowejICAEIQAACELBDAEG34wssgQAEIAABCAQTQNCD0ZERAhCAAAQgYIcAgm7HF1gCAQhAAAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQADYA1d5AAAAgElEQVQCEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE/g/Y48uFC1kKt8AAAAASUVORK5CYII=",
        "mix_doc": "iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0CAYAAADL1t+KAAAAAXNSR0IArs4c6QAAAARzQklUCAgICHwIZIgAACAASURBVHhe7Z1Bj103GYZPVoBUqc0PqNJs2CaR2FaTiB2bZH4ASocdSCidHSuSETs2ySAhNog0GypgMRmxRQoD3SAhpYO6hTQbBBKiRFSiRUih721Pe3PnnnNsH9vns/1YGk3TObY/P5/vfY/tz/a555+kjgQBCEAAAhCAQNEEziHoRfsP4yEAAQhAAAIrAgg6HQECEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEILEDgX//6V3d6etrp97vvvruy4P3331/9bKah/98/98orr3SXL18+k2/9/+vv+velS5dWv0kQgEB9BBD0+nxKiwwQ2BTsXrjXBXxJM3uB73+/9tprnX52dnaWNIu6IQCBGQQQ9BnwyAqBfmSt0bZG2v3PtpF2KbQk8vq5evXqakS/bfRfSluwEwItEUDQW/I2bY1C4OTkpPvtb3+7Em/91qi79iRx74Ueka/d27SvVAIIeqmew+5sBHoBl3jrh9St1uFv3LixGsVfv36ddXk6BQQMEEDQDTgBE2wR0Ij7+Ph4Jd4PHz5sYgQ+1wMSdgm81uCZop9Lk/wQCCOAoIdxI1dlBCTiDx48+FzEK2te1uYouK4XeI3eSRCAQB4CCHoeztRilIBG4m+99dZqJE5KQ0Aj9zfeeGM1NU+CAATSEUDQ07GlZKMEFMym0biEvIWANitu0Lq7hP3WrVurLXIkCEAgLgEEPS5PSjNMQGviBwcHBLYZ8JHW2d98800C6gz4AhPqIYCg1+NLWjJAQKPxe/fufX4iG6DsEGDUbscXWFI+AQS9fB/SghEhv3PnztbjVIFmj4Cm42/fvs10vD3XYFEhBBD0QhyFme4ENLW+v7/PiNwdmakn+3V2tr+ZcgvGFEAAQS/ASZjoRkDHre7t7bFG7obL/FPa+nb//n1G7OY9hYFWCCDoVjyBHbMIKNhN0+uk+ggoeE5T8dwSV59vaVFcAgh6XJ6UlpmAtqBpVN5fQZq5eqrLREBirsDGmzdvZqqRaiBQHgEEvTyfYfFnBBiVt9cVtK5+9+7d1Ul0JAhA4EUCCDo9ojgCOgzm2rVrjMqL81w8g5mGj8eSkuohgKDX48smWqKpdYk5J7w14e7RRuq0OQXNMVqnL0DgUwIIOj2hGAI6qlXb0RDzYlyWxVAFQypojgSB1gkg6K33gELaz3p5IY5ayEytrR8dHbHFbSH+VGuDAIJuww9YMUJAUewanZMgMEZAkfAKmNPBNCQItEgAQW/R6wW1GTEvyFlGTFXAnISdBIHWCCDorXm8kPZqnVzr5YzMC3GYMTN1B7sC5jiMxphjMCcpAQQ9KV4KDyHAtrQQauTZJKB19UePHiHqdI1mCCDozbi6jIYi5mX4qRQrNUKXqHPRSykew845BBD0OfTIG5UAYh4VJ4V9RkCirul3TcOTIFAzAQS9Zu8W1DbEvCBnFWqqRJ0I+EKdh9lOBBB0J0w8lJqATn/TPeYkCKQkoL3qjNRTEqbsJQkg6EvSp+4VAbam0RFyEWBNPRdp6lmCAIK+BHXq/JwAYk5nyE0AUc9NnPpyEUDQc5GmnjMEdAa3jnQlQSA3AUQ9N3Hqy0EAQc9BmTrOENCBMRqdkyCwFAFEfSny1JuKAIKeiizlDhJQ8JuC4EgQWJqArmB9/Pgxh88s7Qjqj0IAQY+CkUJcCXCfuSspnstFQIfOSNRJECidAIJeugcLsp+95gU5qzFTtT9d+9RJECiZAIJesvcKs52I9sIc1pi5uqFNN7WRIFAqAQS9VM8VZve9e/dWt6eRIGCZgM59v3r1qmUTsQ0CgwQQdDpHcgJaN79y5UryeqgAAnMJKPL9yZMnBMnNBUn+RQgg6Itgb6dSrZtLzN9///12Gk1LiyagEbpG6iQIlEYAQS/NY4XZqzXJw8PDwqzG3NYJsJ7eeg8os/0Iepl+K8Jq9psX4SaM3EKAQ2foFiUSQNBL9FoBNjPVXoCTMHGUAPvT6SClEUDQS/NYIfZyTnshjsLMUQK3b9/u1JdJECiBAIJegpcKs1EBcAqE0yidBIHSCegUOY3WSRCwTgBBt+6hAuzTtrTj4+NVJPv6TwGmYyIEJgkQ9T6JiAeMEEDQjTiiJDM08j45OekePnzYKfCNLWkleQ9bQwgcHR11N27cCMlKHghkI4CgZ0NdfkUSbt1frqtPSRBoiYBuZdOBMyQIWCaAoFv2jhHbNArXXnKNyEkQaJWALm/RJS4kCFglgKBb9YwBuyTkGpHrNwkCrRPgWNjWe4D99iPo9n2U3UKtkesiFabWs6OnQuME2MZm3EGNm4egN94BNpuvaXVdc8qWMzoGBM4S0Chd29i0pk6CgDUCCLo1jyxkjwRcQs46+UIOoNpiCNy8eZPZq2K81ZahCHpb/t7aWon5tWvXOu0nJ0EAAtMEFPHOKH2aE0/kJYCg5+VtrjaJuMScKXZzrsEgwwQ4bMawcxo2DUFv2PmIecPOp+mzCTBKn42QAiITQNAjAy2lOILfSvEUdlolcOvWre7evXtWzcOuBgkg6A06XSNzXZ5CggAEwgko4v2DDz4IL4CcEIhMAEGPDNR6cVorv3jxImvm1h2FfUUQ4PS4ItzUjJEIejOu/rShGpkTzd6Y02luMgIExyVDS8EBBBD0AGilZtE+c05/K9V72G2VAMFxVj3Tnl0IeiM+V/COjnMlQQACcQlwHGxcnpQWTgBBD2dXTE5de6p1cxIEIBCfAFerxmdKiWEEEPQwbkXl2t3d5UjXojyGsaURODo66m7cuFGa2dhbGQEEvTKHbjZHV5/qJDgSBCCQjsD169d5aU6Hl5IdCSDojqBKfYyo9lI9h92lEdCedO1NJ0FgKQII+lLkM9TL2nkGyFQBgc8IsCedrrA0AQR9aQ8krP/NN9/sDg8PE9ZA0RCAQE+AaXf6wtIEEPSlPZCw/vPnz3MiXEK+FA2BdQIcBUt/WJoAgr60BxLVTzBcIrCFFnvp0qXPLX/11Ve7f//735//+y9/+cvq3x9++GH3v//9r9AW2jD70aNHnU6PI0FgCQII+hLUM9R5586d7uDgIENNVGGFwIULF1Zioh/tjQ4VFr0M/vGPf+zee++97k9/+lP317/+tfv73/9upZmm7eCQGdPuqd44BL1SF+vL/OTkpNLW0SwR0Ki7F/DLly+vRDxleuedd7pf/vKX3W9+85vuz3/+c/ff//43ZXVFlr2zs9PphYgEgSUIIOhLUM9Q57lz5zLUQhW5CUjEFeyoQ0yW3iL1+9//vvvJT37SaZr5b3/7W24UJutjHd2kW5oxCkGv0NWsn9fl1Jdffnkl4m+88UbyUXgoOV3L+6Mf/aj71a9+tZqqbzk9fvy404wJCQK5CSDouYlnqI+LWDJAzlCF1sQVCyEhLylJ3H/+85+vRu8tijv70UvqrXXZiqDX5c9VawiIK9upWoftp9XLbknX6XAjvWD+7Gc/eyGyvvR2jdlPYFzN3rXdNgTdtn+CrCMgLgjb4pkk5HoZC41OX7wBEwa89dZbK3E/PT21buos+zhgZhY+Ms8ggKDPgGc1K+e3W/XMdrs0tS6xq1XIN1v97rvvdj/84Q9Xl5n85z//KctZDtYS6e4AiUeSEEDQk2BdtlAi3Jfl71p7qWvkru2bek5r7RqxS9xrE/bnz59PNZ+/QyA6AQQ9OtLlC0TQl/fBmAV91LrWyZfeemaFlGYovve971VzgA2CbqVntWUHgl6ZvzXq0RnuJJsEbt68uRqVIuTb/VOLsCPoNj9/tVuFoFfmYfag23So1lUl5OxPdvNP6cKOoLv5mafiEkDQ4/JcvDQEfXEXvGBAawFvsemXKuwIeuyeQHkuBBB0F0oFPYOg23CW1sm1BU3r5KT5BDS7oTX2jz/+eH5hGUpA0DNApoozBBD0yjoFgr6sQ1uPXE9JX/Ehekn68Y9/bPqaV/UBHahDgkBuAgh6buKJ60PQEwMeKL6/NKW0Y1qXoTWvVonlt771rdWlMBbTrVu3VvESJAjkJoCg5yaeuD4EPTHgteIV6KYgN4k4wW75uPc16ba3b37zm93Tp0/zVz5SI5ezmHJHU8Yg6JW5G0FP41Ad5ynR7u8dR8DTcA4p9ac//Wn37W9/28Q0vLYlKpCPBIElCCDoS1BPWCeCHg+uRuAafVu4ezxeq+osSevrr7/++qK3u2nZRZ8/zhios4+V0CoEvQQvediIoHvAGni09ktS5hOyW8L3v//97gc/+EF2AxUIpzPqEfPs6KlwjQCCXll3QNDDHcpWs3B2lnJKWHd3d7NFmnP6nyXvt20Lgl6Z/xH0MIdqulRrn6yNh/GzlktT8N/5zne6t99+O5lpiqvQOQOt3JKXDCQFRyOAoEdDaaMgbem5ePGiDWMKsYK1z0IcFWCmXtK++93vdh9++GFA7hezaAZH4q0fxVW89tprs8ukAAjEJICgx6RppCxuW3N3BGLuzqrUJzUFLxF+9uxZUBNeeuml7he/+EX3jW98Iyg/mSCQiwCCnot0xnoQdDfYGnHpy56Rlhuvkp+aK+rqI9pfTtBbyb2gftsR9Ap9jKC7OfXo6Gg1dUpqg4DW1TVSPz09DWqw4it0Oh2iHoSPTBkIIOgZIOeuQqMJa6dn5WYwVR/Hc04RqvPviHqdfqVVnxJA0CvsCRqFnJycVNiyOE3SVLuCBxlpxeFZWikSdR0YdHx8HGS6ZnU0u0OCgDUCCLo1j0SwB0Efh3j79u3VrV2ktglI1B88eBAEQXnv378flJdMEEhFAEFPRXbBciVWBwcHC1pgt2qutrTrmyUsQ9SXoE6dqQgg6KnILlgugj4M/+7du6vDQEgQ6AnMEXWN0rkyl75khQCCbsUTEe14+PDh6uhL0lkCH3zwAWvndIwzBOaIOtel0qGsEEDQrXgioh0c/7odJldbRuxkFRalYLeQQDn2qFfYGQptEoJeqOPGzOb41+102HdeYWeP2KQ5W9qIfI/oCIoKJoCgB6OznZHDZc7658mTJ5wKZ7vbLm7dHFEnPmNx9zVvAIJeaRfQqVahJ2LViER7z/VlTYLAFAH1E02jh5z9znr6FF3+npIAgp6S7oJlh64HLmhy0qp3dnY6xRaQIOBCIPTsd9bTXejyTCoCCHoqsguXy9a1Fx2AoC/cIQusXqJ+5coVb8tZT/dGRoZIBBD0SCCtFaN7oPf29qyZtZg9CPpi6Iuu+N69e93+/r53G1hP90ZGhggEEPQIEC0Wwda19CN07SbQJThirdEca/QWPwnzbXrvvfe6f/zjH94Ffe1rX+t0l3qKpOOdFSejkw/1mwQBEUDQK+4HRLp/4dyYI3SJt2Y/9JsEgaUJ6JIhnVjHVcBLe2L5+hH05X2QzAKuUf0CrUYxikCemw4PD1cXuzAan0uS/LEJ6EhjXTzELYKxyZZTHoJejq+8LeXWtReRPX/+3JvhegaNyhWbQIKAVQJ6cX306BGibtVBie1C0BMDXrJ4It1fpK8vOr3kuCSNwLWPv18f/93vftf985//dMnKMxBYlID6uPo6qT0CCHrFPifS/UXnDkUeb4q31sYV8OaTFJykJQ4SBFIT6PvrWD3cApfaCzbLR9Bt+iWKVUS6v4jx1q1bq/Xv9ZF3iHj3per0OZWnm7pYt4zSZSnEg4BuVdS6uXZabCa9XOqoY1JbBBD0yv1NpPsXDv7yl7/cffTRR9E8zjGf0VBSUCCBsWNq6Z+BUAvOhqAX7DwX04l0d6Hk/4yiiTU6J0FgaQJDS2scbrO0Z/LXj6DnZ561Rs50T4PbJ8AujQWUCoFPCQxdl8xLZ3s9BEGv3OehR1dWjmV28+ZugZttAAVAYI3AtqU1BL29LoKgV+7z0AsmKscyu3ljgi7mx8fH3O42m3LbBWhPuX5u3rw5CkLr6OfPnz/zDILeXv9B0BvwOYFx8Z08JOhsFYzPuvUSp/aVD+1mYQ29vZ6DoDfgc06Mi+/kbYKutUxdt8mxsPF5t17imDgPCTpxHu31GgS9AZ9zYlx8J28TdO0L3t3djV8ZJTZPYOxyoaF+h6C3120Q9AZ8zgEz8Z28TdB5cYrPmRI/JTAm6EP9TgfLcHphWz0IQW/A30NBMw00PVkTEfRkaCl4C4EQQWcnRntdCUFvxOeKltWRp6Q4BBD0OBwpxY3A9evXO02tb0s6evjBgwdn/oSgu7Gt6SkEvSZvjrRFZz7rLm9SHAIIehyOlOJGYGwL2rag10uXLnXaPklqiwCC3oi/2U4V19EIelyelDZOwFfQx6boYV0vAQS9Xt++0LKh4yEbaX70ZiLo0ZFS4AiBMUHXoTKbWyUR9Da7E4LekN9ZR4/nbAQ9HktKmiYwtgVt28FRuipYxz6T2iKAoDfkb9bR4zkbQY/HkpKmCQwJ+tDRzhz7Os20xicQ9Bq9OtAmznWP52wEPR5LSpomMHS3OafETbNr6QkEvSVvf9JW7keP43AEPQ5HSnEjMLQFbeg2RU6Jc+Na21MIem0enWgP0+5xHI6gx+FIKW4EhgR96JQ49qC7ca3tKQS9No9OtIfzxuM4HEGPw5FSpgmMRaxv24P+8ssvc0HQNNYqn0DQq3TreKNeeeWV7tmzZw22PF6TEfR4LClpnMCYoOt2v80DZNiy1m6PQtAb9P3QUZENoghuMoIejI6MngTGtqBt27J28+bNTgdJkdojgKC35/PVh31vb6/BlsdrMoIejyUljRMY2oI2dOkSW9ba7VEIeoO+5/a1+U5H0OczpAQ3AkMR60Nb1u7fv99pFo7UHgEEvT2fr1p848aN7vj4uNHWz282gj6fISW4ERgSdLasufFr6SkEvSVvr7WVaPd5jkfQ5/EjtzuBoS1oXJvqzrCVJxH0Vjy9pZ0cMhPufAQ9nB053QlcuHCh08VK29K2CHeuTXVnW+OTCHqNXnVs09ChFI7Zm34MQW/a/dkaP7YFbVuE+/Xr1zvNvpHaJICgt+n3Vavfeeed7vXXX2+YQHjTEfRwduR0JzC0ZY1LWdwZtvQkgt6Stz9rq6JjDw4OOv0mhRFA0MO4kcuPwFDE+tDWU85w9+Nb29MIem0eHWmPpuL29/cH1+QaQjHaVB2dqbvjlT766KPuD3/4w5nnEXR6Sw4CQwI9dCfDBx980OkkSFKbBBD0Bvyufec6SIa1te3O/vWvf9299NJLnc7F3kw+l18Qk9DAhylzE4ci3Led4T4WQJfZbKpbiACCvhD4XNVKxCXmEnXSWQJT5177CDon8NHDYhIYi1jfFhA31Zdj2kZZNgkg6Db9MtsqCbjWyXX4BGmYwN27dztNXw4lH0EXc20F5OIbelwMAkNnshMQF4NunWUg6BX6VR/43d1d1sodfPvkyZOVCMcQdJWhUbpeEBB1B/g8Mkpg6GWTE+LoOEMEEPTK+obE/Nq1a0yxO/jVZc3RZ4TeVykf6Gjdp0+fOljBI74E+qBFvYjpRwGMCgTr/63yNFvSXyva/7d2dZycnPhWt9jzjx8//jw4c92Ibevn+vvQevtiDaDi7AQQ9OzI01WYWsxfffXV7qtf/Wr39a9/vfvKV76y9cumb52OpbQuaGPXUvbtCBH0XlDEgPPy4/R3rSdLyPSitC140acWxZVolGtZ3PXSMhT3wvq5j7fbehZBr8TfmurVlrRYwW/6QtEXp340AvL9Ei0hQGxoBLTeJUIFvS9jaHq0km6XtBnqgxJw+WBsWSTUCB2pquURiy9dQwFuQzescWVqaC+oKx+CXoE/Y4qnvkj0Jacv0jnJeoDY2AgopqCrLKbg/XqSfKM+qJ8ce6o1YtdsiqW4h6H186EXTA6U8etjtT6NoBfu2VhirohafYH2B6rEwDJ0G1SMsueWMRRBvFlurC9QveAwBT/tNZ1Frj6dQ8jXrdFoXS+xp6en00ZmeIL18wyQK6wCQS/YqUPbV3yapC9QTQunmtK8ePGijznZnj06OnKahRi6ZjZ0ipMo+O0u1qhcbObODM3pQHrp0tLS0qLO+vkcL7adF0Ev1P/68tH1iUNXK041K9cX6FBE7pR9qf/uekSm+A69lIROc1obDaZmPVW+At4k5qGzQ+vBbWK7/nKqJSSfpM+V7FgyoHNo9mjo5XLqLAWf9vNs2QQQ9EL9p9Pf9CUYkvQlp7wpRuWb9sRaEghp51Ae3ysmh15KNC2sKXlFy4ckjortOom5Ar18ptgVxKY8+um3po3x74M75XeXlwaVqTxLrakPzR4NLWG5BHeG9E/ylEcAQS/PZ6sz2XVwTEha4m1eLw5Ljng2OQ3dYDXEcyiyuH9e08Qq00eU+rwSD31RLz3NG9KX5ubxEXONnA8PD1fLQ3N2ckiotVwytWtjqRfRsen28+fPn2m7y1kKc/1E/nIIIOjl+GplqaYUNdUe8qXmK2Sx0FgbiU6dDret3UO3W/XPSszFN3QNeKr8WL6wUo6PmPdHGIf0+aH2StDlr7FZKvky95Y23+l2l7MUrPgcO9ITQNDTM45ag8TcZZpx7qg0ptH6ItbowkIau/Biyj6XqP05o3XNBJRwIM8Up6m/axSqF9OpGQ09o5mokP4+ZYP+rvo1vT00Wl9i6yXT7S6e45khAgh6QX0jdKS71Mh8Ha2LGOZwRWh0em+by0haoz4xn5rWHWpvqJ9z8ItRh0swYeyDksbsHvt85DwYaGj6XC8WCszcnKFguj1Gb6yrDAS9EH8OfainzF9izXybTVPr0FPtiPX3GAFEaotG4lNBUxJ/vUBMjUS3ta3WtXWXFyrX9esvfelL3ccff7zCp/vs33777dXvPolhHzw35asxUc8VAzL0WR3iwXR7rG+FespB0AvxpeuX3HpzfKO5U6NQhPGSwV8xRzSuB8VIDDSN6hJdvY2/RogasU8JUmrfxSjfZbnDpZ9rl4aYiOn6Us7Yy6vKVZ6h4Ey9dOllb9uaeq6X0aGtlEPLbDFeTmP4lTLsEEDQ7fhi1BJNufnsOXddp8zZfJcv65T2pBjRuB4bKjHR6DQkWT5z3Kc9UwI0tXtj23719aUcibECHoeSXsI0a/LgwYOtj+gFQTZuS6nPU/C9+9zl5cjHNzxbBwEEvQA/hgihyzrlEk3XSGip0abr6XC+XCQUmoKfPnUuaQAAIABJREFUur1LgqGp3dDReslBc1NT7VM3BQ69jG0e/OMSLzK2Lj5k59gBQ779ZfP5sZfvodgTl3bOtYv85RFA0Avwme/ofOrLc8kmuwSVpbDP9TKWOXW7To/3h9GErK3LPuVXXUu9GPkymlrq0AvRtWvXBqPZp8RrfXuZmGqUPsV2SCjHpt5T9d2hz+tQ3EyOvuzrY563QQBBt+GHQSt8R+cWp9rXG5dypDPmylzxBGqfxGJqtK7pYa35hu5bn5o+ttStp2aLtDVN0+3bkktQ5+Yat8sL7di57fKJZnM2U4pjYfWyo9mJbS8gQy8dKZaOLPUXbAkngKCHs8uS0/dwC5cvsyyGj1Ti26YY9k6N8mLUsV6G69YzlwNOxmyTGGjkOPUCEbt9ruVNvUiNTX+73ognW9bXuF1H6WOXGw29hEyt87ty6Z8biisYe/ENORjJ1y6eL5MAgm7cb+fOnXO20ProvG9I7C9FF0Cul7G4lOX6jM/Ws7nT8BqlqgxLwj7VH8fWzRXJrja5ps1RuusodmgaXS8IEvVtyfVlbcr2sZfvodG5z0vOVP38vT4CCLphn/pul4k9OtcXrgRCIx5F1YYGc21DnGtvr+r2FYfYXcJVAMREz+pLOzTpZUllLLk9sLd9arp8aDvW1IvAEJvNSPSpqHqVM3Ya3FgQ5dyDksaEeWzmgNF56CejjXwIumE/uwqBmhD6Jbit+fpC2d/fPzNCmjs9vF5XzhO4poQlRxfwmRoXZ9k85wVq6RH71EvUWN+eWnMf8tfmC/DYKHu9jCFbprbBhYr61ChbAYLbZiem8uXox9RhmwCCbtg/Pue2T61VujZzavuQRuv6wp0jNlMjI1dbXZ+zNKqZOuBkvU1zTprry1lC2KdeLsdmnlynyl1H6S7ljQW7TcVeyJ/yk8uOAwXA6UV2LBBy7EV3iWUj188Yz9kggKDb8MMZK3wvNIk1CnXZIuc68plCGzrCmSp3/e9TW6Z8yor1rHyrL27dIjaV9AKlZ+dMw6sOBVlpJKopeRfxmbJr7O9jI2y1XS+q2w5JinFYyraXBQmuPh9jaWg3iUbpmrof2wanNomrfrbdzqbZCom4+vtYOVMv08+fP5/jFvI2QABBN+pk38CxGKPQsbW7TUyh06Lr5fjUF+omlxFaaNlz87lucVM9MdbXVY7ER+KlnxTr7FMj2r29vVXd25LLmrcL8227KCSmEvUxQR2K6wjpQ/1WtLHrWdfbMrUXX88i6C7eb/sZBN2o/33Wz2ONQn3qDPmS24Y69ZGasUQiZTfRy5tGkUPnjK/XHUvY+1G7Rv+q36XuMQaaZldZEs6hNHamQqwZpv6lRZw2ZyK0TKQX0SFRH1sKSN2PXJbXEPSUn8I6ykbQjfrRZzo6VrCMj6CPnXvtg9T34Byfsks6UctnGj7miL3nqdmCftrYd+ubppTlx7HRaMwtai59YKhfTcWADL1guky9u9i1+Yz8rgDUoVmL/vkYyxEh9pGnLAIIulF/+YxcY41ufCPPYwXppNrCFutFJ2cX8ZmGl13qJ9quGHr3+lDbJMDrP/3IV9P0mhGSz/RSpxfPqQDJselkvXSpHtepaR9fjIm6PjPbZhPEX+3ZFmcwdIKcj03rz7pMs/fPT+0aCLWBfHURQNCN+tNH0GOsZwuD77GsU+ulrmh9ZgZcy9RzqS5j8bEh9Fnfi1jUXzRtr90O1tLYdHJqH43NAOkFVktHm2nsxVYvAer3c5P8q3gC1xsUEfS5xNvIj6Ab9bNLtHlveixBV3k+o+VYI2DfFwlXl8WaQXCtL8VzPtvcev9J2OWbqQtKUti7WeZYEFysOIypdoxdqjIk0BqlDwUNzoljUF8XE59T8NQ+BH3Ky/xdBBB0o/3A58jXmAE7Pmv3Uwdv+KD1qdel3Fj78l3qyvFMyA1rYiphjz0d79reMTHPvSY81r+2ibrLRSy9sOt3vwyxyUbl6MVA8QkScS0vhCQEPYRae3kQdKM+9xH0mNGvvkFqMbbLyQW+x9xOuS3WcsBUPTn/3gfO+V6dKsHJOWqfGoWO3TCWkqevqEt89TLks29fI3vNjIiB63S6S5sRdBdKPIOgG+wDvlPQMQV9qQNt5IaxaU5fN8V60fCtN8fzocIu2yRqEikJRIpAtMPDw9UBNrJxW1IQnF7epgLpUnAcuzJV9W1bugoR9RS2I+gpqNZXJoJu0Ke+ohpT0H2FNebUtu/swJDrck/nLtmFfNfY122VqErcFb0twQhN6q8PHjxY7UMfG5UuKeZ928YEeugERJ9b80IZTuWL+Tmbqou/l0sAQTfqO58p99jBX2NBRJu4NL2o+mOksZuvfMqPfeucT91LPduf/ua7h3zdXgl7P2Xcj6D1crQtuE71SOg02tbP0Ii8L9+CmPe2jEWxjwWYKp9mH3ym4If6g3iIsau/WuzTS32WSq4XQTfqPR9BjxnlLhy+x87GrN/nZWLIdTGDBI12j0GzJLISHo2YYyZNz4euCeulQC8cS0yzDzEY2s0xdWBSf267GPsenSsR72dE9PLkep6/2oCgx+zN9ZaFoBv17RL70NdR+LxQxPyy8Y0f2HRfrGNwjXYLZ7PmCI9zJQ4P5tqa5mDKC4+MLe+4LmGJcT9LocI3t6LppaH/0YvC5gvNtjPnh9oR8zPmy4rnyyGAoBv1lY+gp4jo9qk/dsCOT92b7rMqIEt2M70kxTqz3bUderGSaC61Zc7FzqGX1lwBlT79PNZpkC5ceKZcAgi6Ud8t/fa+1DGwcofvlP+6C1OfPGa0uzib1Z/Znuq2Nb3cadlk7M5vZ2MTPzgkqDGXkMaa4HIhS58/l02JkVN8YgIIemLAocX7HIeaIgLW92rT2F84PifW9YxLuowltF/EzKcp4/6wE/12DdDatEEi3q8NW1onn2I1JOi5prd9lrVif76m2PD3Mgkg6Eb95iPoMSPN13GoXNeI3thfOL4zBLI7xYuN0e6RzKz+QBS90PWR6/1/qz+sC7YE0fKU+hSk8+fPb43OzzW97SPosXeyTLHh72USQNCN+s132jm2oAqLz7R/7MjykC1sKRgY7R6YNZPA2AxUjn7kOwPmGqg3EwvZCyeAoBt2oM8bfIpgMNfjWFNFlutLT+uxU1PB2halE9D0LAkCLgTGZoBiv5xus8f1s6W8LCW5eJRnRABBN9wPfEbIU/tnQ5vpEombIso+1F7yQWCKgGZ/FJC2bV99LvH0mYGLvYtkig9/L5cAgm7Yd77ryCm220ydf50rgMiwmzCtMAK7u7urnRTbUq44DJ8YGQS9sA62oLkI+oLwp6r2PWQl1v3km3ZJ1PujRfvTsfTFpynukoOipvjz9/oITI2Mc6yfi6qPoKdYTqvPs7SIKfcC+oDv9q0Uo/QCMGEiBCYJ6KV0f39/8Nz5nCNhn+U0ZsEmXcsDnxFghG68K/iebZ5qlG4cE+ZBYJCAZpgk5BL0oZT78hifQ2UQdDq3KwEE3ZXUQs/5RMP2JjJKX8hZVGuOgD4/EnPtmBhLuQM7fXaw5FoGMOc8DPImgKB7I8ufwSXSfN0qTefpCFQSBFol0N/PPiXk4pNbzH33oPOC3mov9m83gu7PLHuOkFF6rtOussOgQggMEJBQSsgV+OZy1aum2fVs7sDOqcC89ebl2kZHp6qDAIJeiB99R+lqFlN1hTgXM4MISMB16JBeePXTH1XrUpgixxVpruNscyefCPecgXq5OVBffAIIenymSUoMGaXry0rTdUt8aSWBQKFNEtCoW+LdT59v3jvuCkWjXS1HKdB0yUtkfCLc2bLm6l2eEwEEvaB+EDJKVx6N1EkQKJGA71kM29qoMxP0OdDxwBZebn0i3Fk6K7HXLmczgr4ce++aQ0bpqkRfZAr8IUGgNAK+l/RoilpnN+jH6m1wRLiX1gvLsRdBL8dXK0t9puvWm6Z8EnULI5TCkGPuwgQk6uvR6vrvzSnzXsQXNnWyet8Id65NnUTKA2sEEPTCusPU2epjzdGXoKbfEfXCnI651RAgwr0aV5psCIJu0i3jRuktX9OJz54987YeUfdGRgYIRCNAhHs0lBS0hQCCXmi30DGWe3t7QdZrhK7pd03DkyAAgXwEfAJbiXDP55daakLQC/ak7znvm03Vl4uEXeuPJAhAID0Bn4A4ItzT+6O2GhD0wj2qKfT+StOQpmi0rhcDXQBBggAE0hHw3aXy+PHjRffLpyNByakIIOipyGYq13dbz5BZGqVL2LVnlxF7JudRTVME7t27t7ooxiVx5KsLJZ7ZJICgV9AnFCSnveZzRurrGLS2rh9dxUqCAATiEPDZcsqRr3GYt1YKgl6Jx+dsZxtCoOl4Telrrb3f56svGhIEIOBP4Pz5887nzXMHuj9fcnD0a1V9IIWobwMkke+FnlF8VV2IxiQi4HugDBcrJXJE5cUyQq/QwZp+14UWOZJG7vryYd09B23qKJWAz/q52vj8+fNSm4rdCxJA0BeEn7LqnKKu0boickkQgMB2Aqyf0zNyEEDQc1BeqA4dPqPI9ZAT5XxN1n52vUSQIACBswQuXrzY6eY4l8T6uQslntlGAEGvvF9oXV2innoKXtvddE41CQIQeJGA7xWwrJ/Tg0IJIOih5ArLp0MtJOyxtrZtaz43QxXWKTA3CwHWz7NgppJPCCDojXUDXQ6hL5gU0/BMuzfWmWiuE4ErV668cP3rWKZLly45P+tUOQ81RQBBb8rdnzZWU4BaX9fP06dPoxFg2j0aSgqqhIDvdDsXslTi+IWagaAvBN5KtZqKl7Br/XvuqF0H0WjanQQBCHxKwHe6nfPb6TlzCCDoc+hVlFfBcxJ1ifvJyUlwy46OjriWNZgeGWsj4DPdfuHCBedI+No40Z44BBD0OByrK0UnW2m6UL8PDg6c26eT4/RSQIJA6wSYbm+9B+RvP4Ken3lxNfociqET4548eVJcGzEYArEJ6MV2b2/PuVi2qzmj4sEBAgg6XWOSgO8XE+uAk0iLeqA/ECX28b6a/VGZir2oMfm8CHNdao09IH+bEPT8zIurkanD4lw2y2DFU+jebgmuftaTBFi372lpRb9dk8o8Pj5exWkoEFP/7lN/q59OGqzlsh+1T7eruSaWqlxJ8dwYAQSd/uFEQOe1ux5KQ7S7E1JzD0mEDg8PV5HZ64I7ZKjEXYcVaavVUOpfDiTkrmXevXu3+MBK31ktgknNfRyKNAhBL9Jt+Y323X7DITP5fTSnRonttWvXgg41kbDL3+sjdt+Xg03bS+8/TLfP6Y3kDSWAoIeSayyf77Q7h8yU00HmiPl6KyXoGmlqml7BYK6XkQyRKlXUfT8rTLeX81mxbimCbt1DhuzzmXaX2Yp2jx1IZQhHNaZo2lxT7TGSlltcptZd6yox8tuXJ9Ptrr2B56YIIOhThPj75wR81wW1FqovN5JdAr6jydwt0Uukdk2UlBQM5/NS8/z585Kah62GCSDohp1jzTTfyF32pFvz4Fl7tG6uqHPLqaSpd9+XXqbbLfe88mxD0Mvz2aIWa2uRz93q7Elf1F2jlWutW0eTWk8l7ZrwOepV3EtcUrDeX1q2D0Fv2fsBbdf2o93dXeecjECcUWV/0HetN7uBaxWWIHy+L0hclbpkj6qzbgS9Tr8mbZWm0n2uXSU4Lqk7ggu/ePHi7Ej04Mo9M5Zwrajv7FVJSwme7uLxhQgg6AuBL7naO3fueF3YUsKXccn+CLHddzQZUkfMPNbjMRRfohck12A4HfWqgMRaj72N6XvKcieAoLuz4snPCPhGRutLS6N0vrzsdCEFwikgrqRkORrc9+AllqJK6nnl2Iqgl+MrU5bqEBGfe9Nv377daWRPskEAQY/rB9/lC5ah4vKntE8JIOj0hCACvoJgfco0CELBmXz9Z6GpVkfovlvVdnZ2zG8VtOBvbPAngKD7MyPHZwR8g+MIArLTdUoTdMvXi/qOzvkc2Pkc1GYJgl6bRzO2x3dkwig9o3Mcqjp37pzDUzYesXo3gO9n4MKFC8XsLLDheazwIYCg+9Di2TMEGKWX2yl8bgRbupUWjxFWRLsOkvG5hIZYkqV7Ut31I+h1+zd563y3sDFKT+4S5wp8I7OdC07woMUgMt++LywW25HAXRS5EAEEfSHwtVSrUYpE+tmzZ85Nsjjacja+sgd9Z1iWaL7Fcwx8952LG6PzJXpPW3Ui6G35O0lrfY8QZV96EjcEFep7lG9QJTMyWT2AxXd0brUdM1xDVoMEEHSDTinNJN+DZhit2PKw75kCOa23OJvD6DxnD6AuHwIIug8tnh0k4HuOtUbpuolNU76kZQlIoCTqp6enyxqyUbvV09QYnZvqJhizRgBBpztEIRCylm71CzsKkMIKCfFfyiZa7RuajVJku+uZ7cxGpewllL1JAEGnT0Qj4DtyUcUlXIsZDZDxgnRhi0bqPgGOKZqka0V18I3Fs/91/r1sc03ady6uFtvi2gaeK4cAgl6Or8xbGjLKu3z58mrqnWSDgMRHyydLTb9rZK7tdBYFMGSbH6fC2ejXrViBoLfi6Uzt9D05iynJTI7xqEYvZhL14+Njj1zzH7UYANe3KiQQjlPh5vcJSvAjgKD78eJpBwIhe5s1StdonWSHQMgSSoj12tKl7XOa7readnd3Vzb6JEbnPrR4NgYBBD0GRcp4gUDIxR/6Mtd6OskWAflSo/WnT58mMUxntGsq2/Juh5C9+ozOk3QXCp0ggKDTRZIQCNnbbHnKNQmkQgrVdLNE9+DgIJrFEjyVqfPkLaeQqXa1h2BPy16t1zYEvV7fLtoyBVdpe49PYm+6D638z2rLlkbrJycnsyrXUa6azrcY+LbZsJCpdotH1c5yGJmLIYCgF+Oq8gwNWYMl6t2+nxX4KN/6TsPv7Ox0ymt5en2dfsjSEdvU7Pffmi1E0Gv2roG2SaB9t0AxwjHgOAcTXIVdQq4XAMtBb5vNDZ1qPzo6Mr+M4OBaHimUAIJeqONKMTtklKO28cVYioe71ah724i9RCHvqWu5SMtGPkkBfr6R8D7l8ywEpggg6FOE+PtsAr63salC1tNnY89egIRd6+xKCnYrdRvi3t7e6iXFJ3Gbmg8tnk1FAEFPRZZyPyeg6Ut9ufuuubKeTifKTSDkYCRmlHJ7ifqGCCDo9I0sBEKn3llPz+IeKvmEQMjODIFjqp3uY4UAgm7FEw3Y4XvFao+EE7ca6BwLNzHkFjWZrKl2vQiUErm/MGaqT0wAQU8MmOK/IDDn3m2C5OhJqQioX+oWNd8gONnDYUipvEK5IQQQ9BBq5AkmoJGQ1sZ9r+hUkJxO3yo10CoYGBmTEwgJgpNRVu9sTw6MCswSQNDNuqZew0LOxhYNRL3ePrFUy0KuRJWturM9ZES/VDuptw0CCHobfjbXypCtbGqERugaqZdwbKg56Bj0AoHQiHa2qNGRrBJA0K16pgG7Qk6RQ9Qb6BgZmhgq5jKNq34zOIgqgggg6EHYyBSDQOh6OqIeg367ZcwRc3ZctNtvSmg5gl6Clyq2MXR/OqJecadI2LQ5Yk4QXELHUHQUAgh6FIwUMofAnC9Z1tTnkG8r75x+RhBcW32l1NYi6KV6rjK7Q6ONGalX1hESNWeOmHMlaiKnUGx0Agh6dKQUGEog9CQ5RD2UeBv55oi5Itq1LMT5B230ldJbiaCX7sHK7J8j6uxTr6wzRGjOHDFX9QTBRXACRWQjgKBnQ01FLgTmHA+r8iXqOo5TLwaktgkcHBys7mkPTYh5KDnyLUUAQV+KPPUOEpgr6ipYB9dI2EntEVD/2d3dXU2VhybEPJQc+ZYkgKAvSZ+6k4r61atXO13qwqly7XQ0ibjEXKIemhDzUHLkW5oAgr60B6g/qajrWkuJOkFN9Xe0uVPsIoSY199Pam4hgl6zdytoW4zpd9bVK+gII02IMcWOmNfdR1ppHYLeiqcLbqe+sG/cuNGdnJzMaoXK0AiMKfhZGE1ljjHFjpibcinGzCCAoM+AR9a8BOZsaestlZhL1CXupLIJxJhiR8zL7gNY/yIBBJ0eURSBGKKuBkvQFQWvNXZSWQR0D/n+/v6sKPa+xayZl+V7rB0ngKDTQ4ojMOeY2PXGarSufcq3bt0qjkGLBmvpRUKuw2LmJp0A9/Dhw047IUgQqIUAgl6LJxtrh9ZONcp+9uzZ7JbrS10jNUbrs1EmK0DT63qRm7MdrTdOZ7NLzNn5kMxdFLwQAQR9IfBUO5+A7lOXqJ+ens4v7JMSNJ1/+/ZthD0KzTiFSHg1KpevY6Tr16+vRvgERsagSRnWCCDo1jyCPV4ENGKTEB8fH3vlG3sYYY+GMrigmOvkvRGKmdAJgiQI1EoAQa/Vs421S2vhmpaNlTSC05e/1tcZzcWiOl2ORuLyY4x18r42ptinufNEHQQQ9Dr8SCs+IaDpWY2uY6yr90B7Yb958yZT8Ql7mWIiDg8PVz6MmZhij0mTsqwTQNCtewj7vAikmILvDdB6vV4YJBKk+QTkqwcPHqyC3WKtka9bxRT7fB9RQlkEEPSy/IW1jgRSjNb7qhUNr+l4jdqZjnd0yNpjWh/XaDzmtPq6FdqSphE/Uez+viFH2QQQ9LL9h/UjBFKO1vtqNWLXyJ1R+3hXlC8UuKjRuAQ9VWKKPRVZyi2BAIJegpewcRaBlKP13jCN1CXs2tMuUWHk3q2m0XX+vvhrxBxjD/lQR7h06dLqZYGDYmZ9VMhcOAEEvXAHYr4bAYmJpsm1ZpsjSVj6kXsrB9aIsQRc4i0RT7Euvuk7Ta9LyDVTQoJA6wQQ9NZ7QGPtl9hoi9vcm9t8sEnQJe5a09VIsqa1XU2faypdXPWTM+kQIL2kMRuSkzp1WSaAoFv2DrYlIyDxkRjEOmXO11CN4CXs+i2Rtz6K12j76dOnq/Vv/bd+6yflNPoQUy1paFRunZlvn+B5CMwlgKDPJUj+ogko0lojdonVkkmjTAl8/1u29OvBOzs72UzTzIVEel2wc4+8hxrLOnm2bkBFhRJA0At1HGbHJWBF2Mda1Qt+/8xQAJheCjR63Ywm74V6sw4rgj3Udp30ppcu1snj9nlKq48Agl6fT2nRDAKaytXP0iP2GU2oJqtmJiTiCHk1LqUhiQkg6IkBU3yZBBSlrVF7zEtfyiSR12pFrUvAFd/AGnle9tRWPgEEvXwf0oKEBBQAJmHXD6P2dKC1Pi4R124AotbTcabkugkg6HX7l9ZFJNALe84tbxHNN1mUjs+VkNe0lc8kaIxqggCC3oSbaWRMAhq191PyS217i9me3GVpbby/6IbReG761FczAQS9Zu/StuQEFDkuce+PN415dWty4zNVoCj1/uQ8/UbEM4GnmuYIIOjNuZwGpyTQC7t+t7rmrsA2CXcv4gS3pexxlA2BLwgg6PQGCCQioKl57fHuD2mpee1dQW3ro/BESCkWAhAYIYCg0z0gkJFAL+76LbEvbQ2+P6ZWQWz9QTfccJaxA1EVBBB0+gAE7BLoT2rrz0bvf/fnp+e2XFPmm4KtaXOmznN7gvog4EeAEbofL56GQHYCEvb+KtKhC1GGjnWVsdtG0JvHyOq5bf8ve2OpEAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQAACEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE0DQg9GREQIQgAAEIGCHAIJuxxdYAgEIQAACEAgmgKAHoyMjBCAAAQhAwA4BBN2OL7AEAhCAAAQgEEwAQQ9GR0YIQAACEICAHQIIuh1fYAkEIAABCEAgmACCHoyOjBCAAAQgAAE7BBB0O77AEghAAAIQgEAwAQQ9GB0ZIQABCEAAAnYIIOh2fIElEIAABCAAgWACCHowOjJCAAIQgAAE7BBA0O34AksgAAEIQAACwQQQ9GB0ZIQABCAAAQjYIYCg2/EFlkAAAhCAAASCCSDowejICAEIQAACELBDAEG34wssgQAEIAABCAQTQNCD0ZERAhCAAAQgYIcAgm7HF1gCAQhAAAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQADYA1d5AAAAgElEQVQCEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE/g/Y48uFC1kKt8AAAAASUVORK5CYII="
    }
    return request_util.do_request(uri, data)


# 2.1.22 Retrive merchant card list-v2
def card_list_v2():
    uri = '/v2/openapi/card/list'
    data = {
    }
    return request_util.do_request(uri, data)


# 2.1.23 Inquiry on statement-v2
def card_transaction_record_v2(card_id):
    uri = '/v2/openapi/card/transaction/record'
    data = {
        "card_id": card_id,
        "end_time": "062023",
        "start_time": "042023"
    }
    return request_util.do_request(uri, data)


# 2.1.24 Card transactions-v2
def card_transactions_v2(start_time, end_time):
    uri = '/openapi/card/transactions'
    data = {
        "end_time": end_time,
        "page": 1,
        "size": 200,
        "start_time": start_time
    }
    return request_util.do_request(uri, data)


# 2.1.25 Purchase Crypto Coin
def buy_coin(card_id):
    uri = '/openapi/card/buy/coin'
    data = {
        "card_currency": "usd",
        "card_id": card_id,
        "currency_amount": "188",
        "mc_trade_no": request_util.get_trade_id(),
        "remark": "Remark"
    }
    return request_util.do_request(uri, data)


# 2.1.26 Card Application (Express mode)-v3
def card_apply_quick_v3():
    uri = '/v3/openapi/card/apply/quick'
    data = {
        "card_type_id": "60000001",
        "mobile_code": "86",
        "email": "2759476460@legend.tech",
        "first_name": "Xu",
        "last_name": "Changshuai",
        "user_ip": "192.168.1.3",
        "mobile": "18867758940",
        "first_recharge_amount": "10",
        "pre_apply": "true"
    }
    return request_util.do_request(uri, data)


# 2.1.27 Binding
def binding(mc_trade_no):
    uri = '/openapi/card/binding'
    data = {
        "card_no": "5554790000007009",
        "envelope_no": "888888",
        "mc_trade_no": mc_trade_no,
        "user_identifier": "hypercard@legend.tech"
    }
    return request_util.do_request(uri, data)


# 2.1.28 Binding KYC
def binding_kyc(mc_trade_no):
    uri = '/openapi/card/binding/kyc'
    data = {
        "mc_trade_no": mc_trade_no,
        "base_info": {
            "email": "hyper_binding_005@legend.tech",
            "first_name": "pan",
            "last_name": "gao",
            "mobile": "1888888003",
            "mobile_code": "1",
            "user_ip": "40.77.166.66"
        },
        "kyc_info": {
            "address": "maizidianjie28hao",
            "birthday": "1990-01-01",
            "city": "beijing",
            "country_id": 1,
            "doc_no": 12345678,
            "doc_type": 1,
            "emergency_contact": "John",
            "nationality_id": 2,
            "state": "beijing",
            "zip_code": "100100",
            "gender": 1,
            "sign_img": "",
            "back_doc": "",
            "front_doc": "iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0CAYAAADL1t+KAAAAAXNSR0IArs4c6QAAAARzQklUCAgICHwIZIgAACAASURBVHhe7Z1Bj103GYZPVoBUqc0PqNJs2CaR2FaTiB2bZH4ASocdSCidHSuSETs2ySAhNog0GypgMRmxRQoD3SAhpYO6hTQbBBKiRFSiRUih721Pe3PnnnNsH9vns/1YGk3TObY/P5/vfY/tz/a555+kjgQBCEAAAhCAQNEEziHoRfsP4yEAAQhAAAIrAgg6HQECEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEIQAACEIBABQQQ9AqcSBMgAAEIQAACCDp9AAIQgAAEIFABAQS9AifSBAhAAAIQgACCTh+AAAQgAAEIVEAAQa/AiTQBAhCAAAQggKDTByAAAQhAAAIVEEDQK3AiTYAABCAAAQgg6PQBCEAAAhCAQAUEEPQKnEgTIAABCEAAAgg6fQACEIAABCBQAQEEvQIn0gQIQAACEIAAgk4fgAAEIAABCFRAAEGvwIk0AQIQgAAEIICg0wcgAAEIQAACFRBA0CtwIk2AAAQgAAEIIOj0AQhAAAIQgEAFBBD0CpxIEyAAAQhAAAIIOn0AAhCAAAQgUAEBBL0CJ9IECEAAAhCAAIJOH4AABCAAAQhUQABBr8CJNAECEIAABCCAoNMHIAABCEAAAhUQQNArcCJNgAAEIAABCCDo9AEILEDgX//6V3d6etrp97vvvruy4P3331/9bKah/98/98orr3SXL18+k2/9/+vv+velS5dWv0kQgEB9BBD0+nxKiwwQ2BTsXrjXBXxJM3uB73+/9tprnX52dnaWNIu6IQCBGQQQ9BnwyAqBfmSt0bZG2v3PtpF2KbQk8vq5evXqakS/bfRfSluwEwItEUDQW/I2bY1C4OTkpPvtb3+7Em/91qi79iRx74Ueka/d27SvVAIIeqmew+5sBHoBl3jrh9St1uFv3LixGsVfv36ddXk6BQQMEEDQDTgBE2wR0Ij7+Ph4Jd4PHz5sYgQ+1wMSdgm81uCZop9Lk/wQCCOAoIdxI1dlBCTiDx48+FzEK2te1uYouK4XeI3eSRCAQB4CCHoeztRilIBG4m+99dZqJE5KQ0Aj9zfeeGM1NU+CAATSEUDQ07GlZKMEFMym0biEvIWANitu0Lq7hP3WrVurLXIkCEAgLgEEPS5PSjNMQGviBwcHBLYZ8JHW2d98800C6gz4AhPqIYCg1+NLWjJAQKPxe/fufX4iG6DsEGDUbscXWFI+AQS9fB/SghEhv3PnztbjVIFmj4Cm42/fvs10vD3XYFEhBBD0QhyFme4ENLW+v7/PiNwdmakn+3V2tr+ZcgvGFEAAQS/ASZjoRkDHre7t7bFG7obL/FPa+nb//n1G7OY9hYFWCCDoVjyBHbMIKNhN0+uk+ggoeE5T8dwSV59vaVFcAgh6XJ6UlpmAtqBpVN5fQZq5eqrLREBirsDGmzdvZqqRaiBQHgEEvTyfYfFnBBiVt9cVtK5+9+7d1Ul0JAhA4EUCCDo9ojgCOgzm2rVrjMqL81w8g5mGj8eSkuohgKDX48smWqKpdYk5J7w14e7RRuq0OQXNMVqnL0DgUwIIOj2hGAI6qlXb0RDzYlyWxVAFQypojgSB1gkg6K33gELaz3p5IY5ayEytrR8dHbHFbSH+VGuDAIJuww9YMUJAUewanZMgMEZAkfAKmNPBNCQItEgAQW/R6wW1GTEvyFlGTFXAnISdBIHWCCDorXm8kPZqnVzr5YzMC3GYMTN1B7sC5jiMxphjMCcpAQQ9KV4KDyHAtrQQauTZJKB19UePHiHqdI1mCCDozbi6jIYi5mX4qRQrNUKXqHPRSykew845BBD0OfTIG5UAYh4VJ4V9RkCirul3TcOTIFAzAQS9Zu8W1DbEvCBnFWqqRJ0I+EKdh9lOBBB0J0w8lJqATn/TPeYkCKQkoL3qjNRTEqbsJQkg6EvSp+4VAbam0RFyEWBNPRdp6lmCAIK+BHXq/JwAYk5nyE0AUc9NnPpyEUDQc5GmnjMEdAa3jnQlQSA3AUQ9N3Hqy0EAQc9BmTrOENCBMRqdkyCwFAFEfSny1JuKAIKeiizlDhJQ8JuC4EgQWJqArmB9/Pgxh88s7Qjqj0IAQY+CkUJcCXCfuSspnstFQIfOSNRJECidAIJeugcLsp+95gU5qzFTtT9d+9RJECiZAIJesvcKs52I9sIc1pi5uqFNN7WRIFAqAQS9VM8VZve9e/dWt6eRIGCZgM59v3r1qmUTsQ0CgwQQdDpHcgJaN79y5UryeqgAAnMJKPL9yZMnBMnNBUn+RQgg6Itgb6dSrZtLzN9///12Gk1LiyagEbpG6iQIlEYAQS/NY4XZqzXJw8PDwqzG3NYJsJ7eeg8os/0Iepl+K8Jq9psX4SaM3EKAQ2foFiUSQNBL9FoBNjPVXoCTMHGUAPvT6SClEUDQS/NYIfZyTnshjsLMUQK3b9/u1JdJECiBAIJegpcKs1EBcAqE0yidBIHSCegUOY3WSRCwTgBBt+6hAuzTtrTj4+NVJPv6TwGmYyIEJgkQ9T6JiAeMEEDQjTiiJDM08j45OekePnzYKfCNLWkleQ9bQwgcHR11N27cCMlKHghkI4CgZ0NdfkUSbt1frqtPSRBoiYBuZdOBMyQIWCaAoFv2jhHbNArXXnKNyEkQaJWALm/RJS4kCFglgKBb9YwBuyTkGpHrNwkCrRPgWNjWe4D99iPo9n2U3UKtkesiFabWs6OnQuME2MZm3EGNm4egN94BNpuvaXVdc8qWMzoGBM4S0Chd29i0pk6CgDUCCLo1jyxkjwRcQs46+UIOoNpiCNy8eZPZq2K81ZahCHpb/t7aWon5tWvXOu0nJ0EAAtMEFPHOKH2aE0/kJYCg5+VtrjaJuMScKXZzrsEgwwQ4bMawcxo2DUFv2PmIecPOp+mzCTBKn42QAiITQNAjAy2lOILfSvEUdlolcOvWre7evXtWzcOuBgkg6A06XSNzXZ5CggAEwgko4v2DDz4IL4CcEIhMAEGPDNR6cVorv3jxImvm1h2FfUUQ4PS4ItzUjJEIejOu/rShGpkTzd6Y02luMgIExyVDS8EBBBD0AGilZtE+c05/K9V72G2VAMFxVj3Tnl0IeiM+V/COjnMlQQACcQlwHGxcnpQWTgBBD2dXTE5de6p1cxIEIBCfAFerxmdKiWEEEPQwbkXl2t3d5UjXojyGsaURODo66m7cuFGa2dhbGQEEvTKHbjZHV5/qJDgSBCCQjsD169d5aU6Hl5IdCSDojqBKfYyo9lI9h92lEdCedO1NJ0FgKQII+lLkM9TL2nkGyFQBgc8IsCedrrA0AQR9aQ8krP/NN9/sDg8PE9ZA0RCAQE+AaXf6wtIEEPSlPZCw/vPnz3MiXEK+FA2BdQIcBUt/WJoAgr60BxLVTzBcIrCFFnvp0qXPLX/11Ve7f//735//+y9/+cvq3x9++GH3v//9r9AW2jD70aNHnU6PI0FgCQII+hLUM9R5586d7uDgIENNVGGFwIULF1Zioh/tjQ4VFr0M/vGPf+zee++97k9/+lP317/+tfv73/9upZmm7eCQGdPuqd44BL1SF+vL/OTkpNLW0SwR0Ki7F/DLly+vRDxleuedd7pf/vKX3W9+85vuz3/+c/ff//43ZXVFlr2zs9PphYgEgSUIIOhLUM9Q57lz5zLUQhW5CUjEFeyoQ0yW3iL1+9//vvvJT37SaZr5b3/7W24UJutjHd2kW5oxCkGv0NWsn9fl1Jdffnkl4m+88UbyUXgoOV3L+6Mf/aj71a9+tZqqbzk9fvy404wJCQK5CSDouYlnqI+LWDJAzlCF1sQVCyEhLylJ3H/+85+vRu8tijv70UvqrXXZiqDX5c9VawiIK9upWoftp9XLbknX6XAjvWD+7Gc/eyGyvvR2jdlPYFzN3rXdNgTdtn+CrCMgLgjb4pkk5HoZC41OX7wBEwa89dZbK3E/PT21buos+zhgZhY+Ms8ggKDPgGc1K+e3W/XMdrs0tS6xq1XIN1v97rvvdj/84Q9Xl5n85z//KctZDtYS6e4AiUeSEEDQk2BdtlAi3Jfl71p7qWvkru2bek5r7RqxS9xrE/bnz59PNZ+/QyA6AQQ9OtLlC0TQl/fBmAV91LrWyZfeemaFlGYovve971VzgA2CbqVntWUHgl6ZvzXq0RnuJJsEbt68uRqVIuTb/VOLsCPoNj9/tVuFoFfmYfag23So1lUl5OxPdvNP6cKOoLv5mafiEkDQ4/JcvDQEfXEXvGBAawFvsemXKuwIeuyeQHkuBBB0F0oFPYOg23CW1sm1BU3r5KT5BDS7oTX2jz/+eH5hGUpA0DNApoozBBD0yjoFgr6sQ1uPXE9JX/Ehekn68Y9/bPqaV/UBHahDgkBuAgh6buKJ60PQEwMeKL6/NKW0Y1qXoTWvVonlt771rdWlMBbTrVu3VvESJAjkJoCg5yaeuD4EPTHgteIV6KYgN4k4wW75uPc16ba3b37zm93Tp0/zVz5SI5ezmHJHU8Yg6JW5G0FP41Ad5ynR7u8dR8DTcA4p9ac//Wn37W9/28Q0vLYlKpCPBIElCCDoS1BPWCeCHg+uRuAafVu4ezxeq+osSevrr7/++qK3u2nZRZ8/zhios4+V0CoEvQQvediIoHvAGni09ktS5hOyW8L3v//97gc/+EF2AxUIpzPqEfPs6KlwjQCCXll3QNDDHcpWs3B2lnJKWHd3d7NFmnP6nyXvt20Lgl6Z/xH0MIdqulRrn6yNh/GzlktT8N/5zne6t99+O5lpiqvQOQOt3JKXDCQFRyOAoEdDaaMgbem5ePGiDWMKsYK1z0IcFWCmXtK++93vdh9++GFA7hezaAZH4q0fxVW89tprs8ukAAjEJICgx6RppCxuW3N3BGLuzqrUJzUFLxF+9uxZUBNeeuml7he/+EX3jW98Iyg/mSCQiwCCnot0xnoQdDfYGnHpy56Rlhuvkp+aK+rqI9pfTtBbyb2gftsR9Ap9jKC7OfXo6Gg1dUpqg4DW1TVSPz09DWqw4it0Oh2iHoSPTBkIIOgZIOeuQqMJa6dn5WYwVR/Hc04RqvPviHqdfqVVnxJA0CvsCRqFnJycVNiyOE3SVLuCBxlpxeFZWikSdR0YdHx8HGS6ZnU0u0OCgDUCCLo1j0SwB0Efh3j79u3VrV2ktglI1B88eBAEQXnv378flJdMEEhFAEFPRXbBciVWBwcHC1pgt2qutrTrmyUsQ9SXoE6dqQgg6KnILlgugj4M/+7du6vDQEgQ6AnMEXWN0rkyl75khQCCbsUTEe14+PDh6uhL0lkCH3zwAWvndIwzBOaIOtel0qGsEEDQrXgioh0c/7odJldbRuxkFRalYLeQQDn2qFfYGQptEoJeqOPGzOb41+102HdeYWeP2KQ5W9qIfI/oCIoKJoCgB6OznZHDZc7658mTJ5wKZ7vbLm7dHFEnPmNx9zVvAIJeaRfQqVahJ2LViER7z/VlTYLAFAH1E02jh5z9znr6FF3+npIAgp6S7oJlh64HLmhy0qp3dnY6xRaQIOBCIPTsd9bTXejyTCoCCHoqsguXy9a1Fx2AoC/cIQusXqJ+5coVb8tZT/dGRoZIBBD0SCCtFaN7oPf29qyZtZg9CPpi6Iuu+N69e93+/r53G1hP90ZGhggEEPQIEC0Wwda19CN07SbQJThirdEca/QWPwnzbXrvvfe6f/zjH94Ffe1rX+t0l3qKpOOdFSejkw/1mwQBEUDQK+4HRLp/4dyYI3SJt2Y/9JsEgaUJ6JIhnVjHVcBLe2L5+hH05X2QzAKuUf0CrUYxikCemw4PD1cXuzAan0uS/LEJ6EhjXTzELYKxyZZTHoJejq+8LeXWtReRPX/+3JvhegaNyhWbQIKAVQJ6cX306BGibtVBie1C0BMDXrJ4It1fpK8vOr3kuCSNwLWPv18f/93vftf985//dMnKMxBYlID6uPo6qT0CCHrFPifS/UXnDkUeb4q31sYV8OaTFJykJQ4SBFIT6PvrWD3cApfaCzbLR9Bt+iWKVUS6v4jx1q1bq/Xv9ZF3iHj3per0OZWnm7pYt4zSZSnEg4BuVdS6uXZabCa9XOqoY1JbBBD0yv1NpPsXDv7yl7/cffTRR9E8zjGf0VBSUCCBsWNq6Z+BUAvOhqAX7DwX04l0d6Hk/4yiiTU6J0FgaQJDS2scbrO0Z/LXj6DnZ561Rs50T4PbJ8AujQWUCoFPCQxdl8xLZ3s9BEGv3OehR1dWjmV28+ZugZttAAVAYI3AtqU1BL29LoKgV+7z0AsmKscyu3ljgi7mx8fH3O42m3LbBWhPuX5u3rw5CkLr6OfPnz/zDILeXv9B0BvwOYFx8Z08JOhsFYzPuvUSp/aVD+1mYQ29vZ6DoDfgc06Mi+/kbYKutUxdt8mxsPF5t17imDgPCTpxHu31GgS9AZ9zYlx8J28TdO0L3t3djV8ZJTZPYOxyoaF+h6C3120Q9AZ8zgEz8Z28TdB5cYrPmRI/JTAm6EP9TgfLcHphWz0IQW/A30NBMw00PVkTEfRkaCl4C4EQQWcnRntdCUFvxOeKltWRp6Q4BBD0OBwpxY3A9evXO02tb0s6evjBgwdn/oSgu7Gt6SkEvSZvjrRFZz7rLm9SHAIIehyOlOJGYGwL2rag10uXLnXaPklqiwCC3oi/2U4V19EIelyelDZOwFfQx6boYV0vAQS9Xt++0LKh4yEbaX70ZiLo0ZFS4AiBMUHXoTKbWyUR9Da7E4LekN9ZR4/nbAQ9HktKmiYwtgVt28FRuipYxz6T2iKAoDfkb9bR4zkbQY/HkpKmCQwJ+tDRzhz7Os20xicQ9Bq9OtAmznWP52wEPR5LSpomMHS3OafETbNr6QkEvSVvf9JW7keP43AEPQ5HSnEjMLQFbeg2RU6Jc+Na21MIem0enWgP0+5xHI6gx+FIKW4EhgR96JQ49qC7ca3tKQS9No9OtIfzxuM4HEGPw5FSpgmMRaxv24P+8ssvc0HQNNYqn0DQq3TreKNeeeWV7tmzZw22PF6TEfR4LClpnMCYoOt2v80DZNiy1m6PQtAb9P3QUZENoghuMoIejI6MngTGtqBt27J28+bNTgdJkdojgKC35/PVh31vb6/BlsdrMoIejyUljRMY2oI2dOkSW9ba7VEIeoO+5/a1+U5H0OczpAQ3AkMR60Nb1u7fv99pFo7UHgEEvT2fr1p848aN7vj4uNHWz282gj6fISW4ERgSdLasufFr6SkEvSVvr7WVaPd5jkfQ5/EjtzuBoS1oXJvqzrCVJxH0Vjy9pZ0cMhPufAQ9nB053QlcuHCh08VK29K2CHeuTXVnW+OTCHqNXnVs09ChFI7Zm34MQW/a/dkaP7YFbVuE+/Xr1zvNvpHaJICgt+n3Vavfeeed7vXXX2+YQHjTEfRwduR0JzC0ZY1LWdwZtvQkgt6Stz9rq6JjDw4OOv0mhRFA0MO4kcuPwFDE+tDWU85w9+Nb29MIem0eHWmPpuL29/cH1+QaQjHaVB2dqbvjlT766KPuD3/4w5nnEXR6Sw4CQwI9dCfDBx980OkkSFKbBBD0Bvyufec6SIa1te3O/vWvf9299NJLnc7F3kw+l18Qk9DAhylzE4ci3Led4T4WQJfZbKpbiACCvhD4XNVKxCXmEnXSWQJT5177CDon8NHDYhIYi1jfFhA31Zdj2kZZNgkg6Db9MtsqCbjWyXX4BGmYwN27dztNXw4lH0EXc20F5OIbelwMAkNnshMQF4NunWUg6BX6VR/43d1d1sodfPvkyZOVCMcQdJWhUbpeEBB1B/g8Mkpg6GWTE+LoOEMEEPTK+obE/Nq1a0yxO/jVZc3RZ4TeVykf6Gjdp0+fOljBI74E+qBFvYjpRwGMCgTr/63yNFvSXyva/7d2dZycnPhWt9jzjx8//jw4c92Ibevn+vvQevtiDaDi7AQQ9OzI01WYWsxfffXV7qtf/Wr39a9/vfvKV76y9cumb52OpbQuaGPXUvbtCBH0XlDEgPPy4/R3rSdLyPSitC140acWxZVolGtZ3PXSMhT3wvq5j7fbehZBr8TfmurVlrRYwW/6QtEXp340AvL9Ei0hQGxoBLTeJUIFvS9jaHq0km6XtBnqgxJw+WBsWSTUCB2pquURiy9dQwFuQzescWVqaC+oKx+CXoE/Y4qnvkj0Jacv0jnJeoDY2AgopqCrLKbg/XqSfKM+qJ8ce6o1YtdsiqW4h6H186EXTA6U8etjtT6NoBfu2VhirohafYH2B6rEwDJ0G1SMsueWMRRBvFlurC9QveAwBT/tNZ1Frj6dQ8jXrdFoXS+xp6en00ZmeIL18wyQK6wCQS/YqUPbV3yapC9QTQunmtK8ePGijznZnj06OnKahRi6ZjZ0ipMo+O0u1qhcbObODM3pQHrp0tLS0qLO+vkcL7adF0Ev1P/68tH1iUNXK041K9cX6FBE7pR9qf/uekSm+A69lIROc1obDaZmPVW+At4k5qGzQ+vBbWK7/nKqJSSfpM+V7FgyoHNo9mjo5XLqLAWf9vNs2QQQ9EL9p9Pf9CUYkvQlp7wpRuWb9sRaEghp51Ae3ysmh15KNC2sKXlFy4ckjortOom5Ar18ptgVxKY8+um3po3x74M75XeXlwaVqTxLrakPzR4NLWG5BHeG9E/ylEcAQS/PZ6sz2XVwTEha4m1eLw5Ljng2OQ3dYDXEcyiyuH9e08Qq00eU+rwSD31RLz3NG9KX5ubxEXONnA8PD1fLQ3N2ckiotVwytWtjqRfRsen28+fPn2m7y1kKc/1E/nIIIOjl+GplqaYUNdUe8qXmK2Sx0FgbiU6dDret3UO3W/XPSszFN3QNeKr8WL6wUo6PmPdHGIf0+aH2StDlr7FZKvky95Y23+l2l7MUrPgcO9ITQNDTM45ag8TcZZpx7qg0ptH6ItbowkIau/Biyj6XqP05o3XNBJRwIM8Up6m/axSqF9OpGQ09o5mokP4+ZYP+rvo1vT00Wl9i6yXT7S6e45khAgh6QX0jdKS71Mh8Ha2LGOZwRWh0em+by0haoz4xn5rWHWpvqJ9z8ItRh0swYeyDksbsHvt85DwYaGj6XC8WCszcnKFguj1Gb6yrDAS9EH8OfainzF9izXybTVPr0FPtiPX3GAFEaotG4lNBUxJ/vUBMjUS3ta3WtXWXFyrX9esvfelL3ccff7zCp/vs33777dXvPolhHzw35asxUc8VAzL0WR3iwXR7rG+FespB0AvxpeuX3HpzfKO5U6NQhPGSwV8xRzSuB8VIDDSN6hJdvY2/RogasU8JUmrfxSjfZbnDpZ9rl4aYiOn6Us7Yy6vKVZ6h4Ey9dOllb9uaeq6X0aGtlEPLbDFeTmP4lTLsEEDQ7fhi1BJNufnsOXddp8zZfJcv65T2pBjRuB4bKjHR6DQkWT5z3Kc9UwI0tXtj23719aUcibECHoeSXsI0a/LgwYOtj+gFQTZuS6nPU/C9+9zl5cjHNzxbBwEEvQA/hgihyzrlEk3XSGip0abr6XC+XCQUmoKfPnUuaQAAIABJREFUur1LgqGp3dDReslBc1NT7VM3BQ69jG0e/OMSLzK2Lj5k59gBQ779ZfP5sZfvodgTl3bOtYv85RFA0Avwme/ofOrLc8kmuwSVpbDP9TKWOXW7To/3h9GErK3LPuVXXUu9GPkymlrq0AvRtWvXBqPZp8RrfXuZmGqUPsV2SCjHpt5T9d2hz+tQ3EyOvuzrY563QQBBt+GHQSt8R+cWp9rXG5dypDPmylzxBGqfxGJqtK7pYa35hu5bn5o+ttStp2aLtDVN0+3bkktQ5+Yat8sL7di57fKJZnM2U4pjYfWyo9mJbS8gQy8dKZaOLPUXbAkngKCHs8uS0/dwC5cvsyyGj1Ti26YY9k6N8mLUsV6G69YzlwNOxmyTGGjkOPUCEbt9ruVNvUiNTX+73ognW9bXuF1H6WOXGw29hEyt87ty6Z8biisYe/ENORjJ1y6eL5MAgm7cb+fOnXO20ProvG9I7C9FF0Cul7G4lOX6jM/Ws7nT8BqlqgxLwj7VH8fWzRXJrja5ps1RuusodmgaXS8IEvVtyfVlbcr2sZfvodG5z0vOVP38vT4CCLphn/pul4k9OtcXrgRCIx5F1YYGc21DnGtvr+r2FYfYXcJVAMREz+pLOzTpZUllLLk9sLd9arp8aDvW1IvAEJvNSPSpqHqVM3Ya3FgQ5dyDksaEeWzmgNF56CejjXwIumE/uwqBmhD6Jbit+fpC2d/fPzNCmjs9vF5XzhO4poQlRxfwmRoXZ9k85wVq6RH71EvUWN+eWnMf8tfmC/DYKHu9jCFbprbBhYr61ChbAYLbZiem8uXox9RhmwCCbtg/Pue2T61VujZzavuQRuv6wp0jNlMjI1dbXZ+zNKqZOuBkvU1zTprry1lC2KdeLsdmnlynyl1H6S7ljQW7TcVeyJ/yk8uOAwXA6UV2LBBy7EV3iWUj188Yz9kggKDb8MMZK3wvNIk1CnXZIuc68plCGzrCmSp3/e9TW6Z8yor1rHyrL27dIjaV9AKlZ+dMw6sOBVlpJKopeRfxmbJr7O9jI2y1XS+q2w5JinFYyraXBQmuPh9jaWg3iUbpmrof2wanNomrfrbdzqbZCom4+vtYOVMv08+fP5/jFvI2QABBN+pk38CxGKPQsbW7TUyh06Lr5fjUF+omlxFaaNlz87lucVM9MdbXVY7ER+KlnxTr7FMj2r29vVXd25LLmrcL8227KCSmEvUxQR2K6wjpQ/1WtLHrWdfbMrUXX88i6C7eb/sZBN2o/33Wz2ONQn3qDPmS24Y69ZGasUQiZTfRy5tGkUPnjK/XHUvY+1G7Rv+q36XuMQaaZldZEs6hNHamQqwZpv6lRZw2ZyK0TKQX0SFRH1sKSN2PXJbXEPSUn8I6ykbQjfrRZzo6VrCMj6CPnXvtg9T34Byfsks6UctnGj7miL3nqdmCftrYd+ubppTlx7HRaMwtai59YKhfTcWADL1guky9u9i1+Yz8rgDUoVmL/vkYyxEh9pGnLAIIulF/+YxcY41ufCPPYwXppNrCFutFJ2cX8ZmGl13qJ9quGHr3+lDbJMDrP/3IV9P0mhGSz/RSpxfPqQDJselkvXSpHtepaR9fjIm6PjPbZhPEX+3ZFmcwdIKcj03rz7pMs/fPT+0aCLWBfHURQNCN+tNH0GOsZwuD77GsU+ulrmh9ZgZcy9RzqS5j8bEh9Fnfi1jUXzRtr90O1tLYdHJqH43NAOkFVktHm2nsxVYvAer3c5P8q3gC1xsUEfS5xNvIj6Ab9bNLtHlveixBV3k+o+VYI2DfFwlXl8WaQXCtL8VzPtvcev9J2OWbqQtKUti7WeZYEFysOIypdoxdqjIk0BqlDwUNzoljUF8XE59T8NQ+BH3Ky/xdBBB0o/3A58jXmAE7Pmv3Uwdv+KD1qdel3Fj78l3qyvFMyA1rYiphjz0d79reMTHPvSY81r+2ibrLRSy9sOt3vwyxyUbl6MVA8QkScS0vhCQEPYRae3kQdKM+9xH0mNGvvkFqMbbLyQW+x9xOuS3WcsBUPTn/3gfO+V6dKsHJOWqfGoWO3TCWkqevqEt89TLks29fI3vNjIiB63S6S5sRdBdKPIOgG+wDvlPQMQV9qQNt5IaxaU5fN8V60fCtN8fzocIu2yRqEikJRIpAtMPDw9UBNrJxW1IQnF7epgLpUnAcuzJV9W1bugoR9RS2I+gpqNZXJoJu0Ke+ohpT0H2FNebUtu/swJDrck/nLtmFfNfY122VqErcFb0twQhN6q8PHjxY7UMfG5UuKeZ928YEeugERJ9b80IZTuWL+Tmbqou/l0sAQTfqO58p99jBX2NBRJu4NL2o+mOksZuvfMqPfeucT91LPduf/ua7h3zdXgl7P2Xcj6D1crQtuE71SOg02tbP0Ii8L9+CmPe2jEWxjwWYKp9mH3ym4If6g3iIsau/WuzTS32WSq4XQTfqPR9BjxnlLhy+x87GrN/nZWLIdTGDBI12j0GzJLISHo2YYyZNz4euCeulQC8cS0yzDzEY2s0xdWBSf267GPsenSsR72dE9PLkep6/2oCgx+zN9ZaFoBv17RL70NdR+LxQxPyy8Y0f2HRfrGNwjXYLZ7PmCI9zJQ4P5tqa5mDKC4+MLe+4LmGJcT9LocI3t6LppaH/0YvC5gvNtjPnh9oR8zPmy4rnyyGAoBv1lY+gp4jo9qk/dsCOT92b7rMqIEt2M70kxTqz3bUderGSaC61Zc7FzqGX1lwBlT79PNZpkC5ceKZcAgi6Ud8t/fa+1DGwcofvlP+6C1OfPGa0uzib1Z/Znuq2Nb3cadlk7M5vZ2MTPzgkqDGXkMaa4HIhS58/l02JkVN8YgIIemLAocX7HIeaIgLW92rT2F84PifW9YxLuowltF/EzKcp4/6wE/12DdDatEEi3q8NW1onn2I1JOi5prd9lrVif76m2PD3Mgkg6Eb95iPoMSPN13GoXNeI3thfOL4zBLI7xYuN0e6RzKz+QBS90PWR6/1/qz+sC7YE0fKU+hSk8+fPb43OzzW97SPosXeyTLHh72USQNCN+s132jm2oAqLz7R/7MjykC1sKRgY7R6YNZPA2AxUjn7kOwPmGqg3EwvZCyeAoBt2oM8bfIpgMNfjWFNFlutLT+uxU1PB2halE9D0LAkCLgTGZoBiv5xus8f1s6W8LCW5eJRnRABBN9wPfEbIU/tnQ5vpEombIso+1F7yQWCKgGZ/FJC2bV99LvH0mYGLvYtkig9/L5cAgm7Yd77ryCm220ydf50rgMiwmzCtMAK7u7urnRTbUq44DJ8YGQS9sA62oLkI+oLwp6r2PWQl1v3km3ZJ1PujRfvTsfTFpynukoOipvjz9/oITI2Mc6yfi6qPoKdYTqvPs7SIKfcC+oDv9q0Uo/QCMGEiBCYJ6KV0f39/8Nz5nCNhn+U0ZsEmXcsDnxFghG68K/iebZ5qlG4cE+ZBYJCAZpgk5BL0oZT78hifQ2UQdDq3KwEE3ZXUQs/5RMP2JjJKX8hZVGuOgD4/EnPtmBhLuQM7fXaw5FoGMOc8DPImgKB7I8ufwSXSfN0qTefpCFQSBFol0N/PPiXk4pNbzH33oPOC3mov9m83gu7PLHuOkFF6rtOussOgQggMEJBQSsgV+OZy1aum2fVs7sDOqcC89ebl2kZHp6qDAIJeiB99R+lqFlN1hTgXM4MISMB16JBeePXTH1XrUpgixxVpruNscyefCPecgXq5OVBffAIIenymSUoMGaXry0rTdUt8aSWBQKFNEtCoW+LdT59v3jvuCkWjXS1HKdB0yUtkfCLc2bLm6l2eEwEEvaB+EDJKVx6N1EkQKJGA71kM29qoMxP0OdDxwBZebn0i3Fk6K7HXLmczgr4ce++aQ0bpqkRfZAr8IUGgNAK+l/RoilpnN+jH6m1wRLiX1gvLsRdBL8dXK0t9puvWm6Z8EnULI5TCkGPuwgQk6uvR6vrvzSnzXsQXNnWyet8Id65NnUTKA2sEEPTCusPU2epjzdGXoKbfEfXCnI651RAgwr0aV5psCIJu0i3jRuktX9OJz54987YeUfdGRgYIRCNAhHs0lBS0hQCCXmi30DGWe3t7QdZrhK7pd03DkyAAgXwEfAJbiXDP55daakLQC/ak7znvm03Vl4uEXeuPJAhAID0Bn4A4ItzT+6O2GhD0wj2qKfT+StOQpmi0rhcDXQBBggAE0hHw3aXy+PHjRffLpyNByakIIOipyGYq13dbz5BZGqVL2LVnlxF7JudRTVME7t27t7ooxiVx5KsLJZ7ZJICgV9AnFCSnveZzRurrGLS2rh9dxUqCAATiEPDZcsqRr3GYt1YKgl6Jx+dsZxtCoOl4Telrrb3f56svGhIEIOBP4Pz5887nzXMHuj9fcnD0a1V9IIWobwMkke+FnlF8VV2IxiQi4HugDBcrJXJE5cUyQq/QwZp+14UWOZJG7vryYd09B23qKJWAz/q52vj8+fNSm4rdCxJA0BeEn7LqnKKu0boickkQgMB2Aqyf0zNyEEDQc1BeqA4dPqPI9ZAT5XxN1n52vUSQIACBswQuXrzY6eY4l8T6uQslntlGAEGvvF9oXV2innoKXtvddE41CQIQeJGA7xWwrJ/Tg0IJIOih5ArLp0MtJOyxtrZtaz43QxXWKTA3CwHWz7NgppJPCCDojXUDXQ6hL5gU0/BMuzfWmWiuE4ErV668cP3rWKZLly45P+tUOQ81RQBBb8rdnzZWU4BaX9fP06dPoxFg2j0aSgqqhIDvdDsXslTi+IWagaAvBN5KtZqKl7Br/XvuqF0H0WjanQQBCHxKwHe6nfPb6TlzCCDoc+hVlFfBcxJ1ifvJyUlwy46OjriWNZgeGWsj4DPdfuHCBedI+No40Z44BBD0OByrK0UnW2m6UL8PDg6c26eT4/RSQIJA6wSYbm+9B+RvP4Ken3lxNfociqET4548eVJcGzEYArEJ6MV2b2/PuVi2qzmj4sEBAgg6XWOSgO8XE+uAk0iLeqA/ECX28b6a/VGZir2oMfm8CHNdao09IH+bEPT8zIurkanD4lw2y2DFU+jebgmuftaTBFi372lpRb9dk8o8Pj5exWkoEFP/7lN/q59OGqzlsh+1T7eruSaWqlxJ8dwYAQSd/uFEQOe1ux5KQ7S7E1JzD0mEDg8PV5HZ64I7ZKjEXYcVaavVUOpfDiTkrmXevXu3+MBK31ktgknNfRyKNAhBL9Jt+Y323X7DITP5fTSnRonttWvXgg41kbDL3+sjdt+Xg03bS+8/TLfP6Y3kDSWAoIeSayyf77Q7h8yU00HmiPl6KyXoGmlqml7BYK6XkQyRKlXUfT8rTLeX81mxbimCbt1DhuzzmXaX2Yp2jx1IZQhHNaZo2lxT7TGSlltcptZd6yox8tuXJ9Ptrr2B56YIIOhThPj75wR81wW1FqovN5JdAr6jydwt0Uukdk2UlBQM5/NS8/z585Kah62GCSDohp1jzTTfyF32pFvz4Fl7tG6uqHPLqaSpd9+XXqbbLfe88mxD0Mvz2aIWa2uRz93q7Elf1F2jlWutW0eTWk8l7ZrwOepV3EtcUrDeX1q2D0Fv2fsBbdf2o93dXeecjECcUWV/0HetN7uBaxWWIHy+L0hclbpkj6qzbgS9Tr8mbZWm0n2uXSU4Lqk7ggu/ePHi7Ej04Mo9M5Zwrajv7FVJSwme7uLxhQgg6AuBL7naO3fueF3YUsKXccn+CLHddzQZUkfMPNbjMRRfohck12A4HfWqgMRaj72N6XvKcieAoLuz4snPCPhGRutLS6N0vrzsdCEFwikgrqRkORrc9+AllqJK6nnl2Iqgl+MrU5bqEBGfe9Nv377daWRPskEAQY/rB9/lC5ah4vKntE8JIOj0hCACvoJgfco0CELBmXz9Z6GpVkfovlvVdnZ2zG8VtOBvbPAngKD7MyPHZwR8g+MIArLTdUoTdMvXi/qOzvkc2Pkc1GYJgl6bRzO2x3dkwig9o3Mcqjp37pzDUzYesXo3gO9n4MKFC8XsLLDheazwIYCg+9Di2TMEGKWX2yl8bgRbupUWjxFWRLsOkvG5hIZYkqV7Ut31I+h1+zd563y3sDFKT+4S5wp8I7OdC07woMUgMt++LywW25HAXRS5EAEEfSHwtVSrUYpE+tmzZ85Nsjjacja+sgd9Z1iWaL7Fcwx8952LG6PzJXpPW3Ui6G35O0lrfY8QZV96EjcEFep7lG9QJTMyWT2AxXd0brUdM1xDVoMEEHSDTinNJN+DZhit2PKw75kCOa23OJvD6DxnD6AuHwIIug8tnh0k4HuOtUbpuolNU76kZQlIoCTqp6enyxqyUbvV09QYnZvqJhizRgBBpztEIRCylm71CzsKkMIKCfFfyiZa7RuajVJku+uZ7cxGpewllL1JAEGnT0Qj4DtyUcUlXIsZDZDxgnRhi0bqPgGOKZqka0V18I3Fs/91/r1sc03ady6uFtvi2gaeK4cAgl6Or8xbGjLKu3z58mrqnWSDgMRHyydLTb9rZK7tdBYFMGSbH6fC2ejXrViBoLfi6Uzt9D05iynJTI7xqEYvZhL14+Njj1zzH7UYANe3KiQQjlPh5vcJSvAjgKD78eJpBwIhe5s1StdonWSHQMgSSoj12tKl7XOa7readnd3Vzb6JEbnPrR4NgYBBD0GRcp4gUDIxR/6Mtd6OskWAflSo/WnT58mMUxntGsq2/Juh5C9+ozOk3QXCp0ggKDTRZIQCNnbbHnKNQmkQgrVdLNE9+DgIJrFEjyVqfPkLaeQqXa1h2BPy16t1zYEvV7fLtoyBVdpe49PYm+6D638z2rLlkbrJycnsyrXUa6azrcY+LbZsJCpdotH1c5yGJmLIYCgF+Oq8gwNWYMl6t2+nxX4KN/6TsPv7Ox0ymt5en2dfsjSEdvU7Pffmi1E0Gv2roG2SaB9t0AxwjHgOAcTXIVdQq4XAMtBb5vNDZ1qPzo6Mr+M4OBaHimUAIJeqONKMTtklKO28cVYioe71ah724i9RCHvqWu5SMtGPkkBfr6R8D7l8ywEpggg6FOE+PtsAr63salC1tNnY89egIRd6+xKCnYrdRvi3t7e6iXFJ3Gbmg8tnk1FAEFPRZZyPyeg6Ut9ufuuubKeTifKTSDkYCRmlHJ7ifqGCCDo9I0sBEKn3llPz+IeKvmEQMjODIFjqp3uY4UAgm7FEw3Y4XvFao+EE7ca6BwLNzHkFjWZrKl2vQiUErm/MGaqT0wAQU8MmOK/IDDn3m2C5OhJqQioX+oWNd8gONnDYUipvEK5IQQQ9BBq5AkmoJGQ1sZ9r+hUkJxO3yo10CoYGBmTEwgJgpNRVu9sTw6MCswSQNDNuqZew0LOxhYNRL3ePrFUy0KuRJWturM9ZES/VDuptw0CCHobfjbXypCtbGqERugaqZdwbKg56Bj0AoHQiHa2qNGRrBJA0K16pgG7Qk6RQ9Qb6BgZmhgq5jKNq34zOIgqgggg6EHYyBSDQOh6OqIeg367ZcwRc3ZctNtvSmg5gl6Clyq2MXR/OqJecadI2LQ5Yk4QXELHUHQUAgh6FIwUMofAnC9Z1tTnkG8r75x+RhBcW32l1NYi6KV6rjK7Q6ONGalX1hESNWeOmHMlaiKnUGx0Agh6dKQUGEog9CQ5RD2UeBv55oi5Itq1LMT5B230ldJbiaCX7sHK7J8j6uxTr6wzRGjOHDFX9QTBRXACRWQjgKBnQ01FLgTmHA+r8iXqOo5TLwaktgkcHBys7mkPTYh5KDnyLUUAQV+KPPUOEpgr6ipYB9dI2EntEVD/2d3dXU2VhybEPJQc+ZYkgKAvSZ+6k4r61atXO13qwqly7XQ0ibjEXKIemhDzUHLkW5oAgr60B6g/qajrWkuJOkFN9Xe0uVPsIoSY199Pam4hgl6zdytoW4zpd9bVK+gII02IMcWOmNfdR1ppHYLeiqcLbqe+sG/cuNGdnJzMaoXK0AiMKfhZGE1ljjHFjpibcinGzCCAoM+AR9a8BOZsaestlZhL1CXupLIJxJhiR8zL7gNY/yIBBJ0eURSBGKKuBkvQFQWvNXZSWQR0D/n+/v6sKPa+xayZl+V7rB0ngKDTQ4ojMOeY2PXGarSufcq3bt0qjkGLBmvpRUKuw2LmJp0A9/Dhw047IUgQqIUAgl6LJxtrh9ZONcp+9uzZ7JbrS10jNUbrs1EmK0DT63qRm7MdrTdOZ7NLzNn5kMxdFLwQAQR9IfBUO5+A7lOXqJ+ens4v7JMSNJ1/+/ZthD0KzTiFSHg1KpevY6Tr16+vRvgERsagSRnWCCDo1jyCPV4ENGKTEB8fH3vlG3sYYY+GMrigmOvkvRGKmdAJgiQI1EoAQa/Vs421S2vhmpaNlTSC05e/1tcZzcWiOl2ORuLyY4x18r42ptinufNEHQQQ9Dr8SCs+IaDpWY2uY6yr90B7Yb958yZT8Ql7mWIiDg8PVz6MmZhij0mTsqwTQNCtewj7vAikmILvDdB6vV4YJBKk+QTkqwcPHqyC3WKtka9bxRT7fB9RQlkEEPSy/IW1jgRSjNb7qhUNr+l4jdqZjnd0yNpjWh/XaDzmtPq6FdqSphE/Uez+viFH2QQQ9LL9h/UjBFKO1vtqNWLXyJ1R+3hXlC8UuKjRuAQ9VWKKPRVZyi2BAIJegpewcRaBlKP13jCN1CXs2tMuUWHk3q2m0XX+vvhrxBxjD/lQR7h06dLqZYGDYmZ9VMhcOAEEvXAHYr4bAYmJpsm1ZpsjSVj6kXsrB9aIsQRc4i0RT7Euvuk7Ta9LyDVTQoJA6wQQ9NZ7QGPtl9hoi9vcm9t8sEnQJe5a09VIsqa1XU2faypdXPWTM+kQIL2kMRuSkzp1WSaAoFv2DrYlIyDxkRjEOmXO11CN4CXs+i2Rtz6K12j76dOnq/Vv/bd+6yflNPoQUy1paFRunZlvn+B5CMwlgKDPJUj+ogko0lojdonVkkmjTAl8/1u29OvBOzs72UzTzIVEel2wc4+8hxrLOnm2bkBFhRJA0At1HGbHJWBF2Mda1Qt+/8xQAJheCjR63Ywm74V6sw4rgj3Udp30ppcu1snj9nlKq48Agl6fT2nRDAKaytXP0iP2GU2oJqtmJiTiCHk1LqUhiQkg6IkBU3yZBBSlrVF7zEtfyiSR12pFrUvAFd/AGnle9tRWPgEEvXwf0oKEBBQAJmHXD6P2dKC1Pi4R124AotbTcabkugkg6HX7l9ZFJNALe84tbxHNN1mUjs+VkNe0lc8kaIxqggCC3oSbaWRMAhq191PyS217i9me3GVpbby/6IbReG761FczAQS9Zu/StuQEFDkuce+PN415dWty4zNVoCj1/uQ8/UbEM4GnmuYIIOjNuZwGpyTQC7t+t7rmrsA2CXcv4gS3pexxlA2BLwgg6PQGCCQioKl57fHuD2mpee1dQW3ro/BESCkWAhAYIYCg0z0gkJFAL+76LbEvbQ2+P6ZWQWz9QTfccJaxA1EVBBB0+gAE7BLoT2rrz0bvf/fnp+e2XFPmm4KtaXOmznN7gvog4EeAEbofL56GQHYCEvb+KtKhC1GGjnWVsdtG0JvHyOq5bf8ve2OpEAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQAACEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE0DQg9GREQIQgAAEIGCHAIJuxxdYAgEIQAACEAgmgKAHoyMjBCAAAQhAwA4BBN2OL7AEAhCAAAQgEEwAQQ9GR0YIQAACEICAHQIIuh1fYAkEIAABCEAgmACCHoyOjBCAAAQgAAE7BBB0O77AEghAAAIQgEAwAQQ9GB0ZIQABCEAAAnYIIOh2fIElEIAABCAAgWACCHowOjJCAAIQgAAE7BBA0O34AksgAAEIQAACwQQQ9GB0ZIQABCAAAQjYIYCg2/EFlkAAAhCAAASCCSDowejICAEIQAACELBDAEG34wssgQAEIAABCAQTQNCD0ZERAhCAAAQgYIcAgm7HF1gCAQhAAAIQCCaAoAejIyMEIAABCEDADgEE3Y4vsAQCEIAABCAQTABBD0ZHRghAAAIQgIAdAgi6HV9gCQQgAAEIQCCYAIIejI6MEIAABCAAATsEEHQ7vsASCEAAAhCAQDABBD0YHRkhAAEIQAACdggg6HZ8gSUQgAAEIACBYAIIejA6MkIAAhCAAATsEEDQ7fgCSyAAAQhAAALBBBD0YHRkhAAEIAABCNghgKDb8QWWQAACEIAABIIJIOjB6MgIAQhAAAIQsEMAQbfjCyyBAAQgAAEIBBNA0IPRkRECEIAABCBghwCCbscXWAIBCEAAAhAIJoCgB6MjIwQgAAEIQMAOAQTdji+wBAIQgAAEIBBMAEEPRkdGCEAAAhCAgB0CCLodX2AJBCAAAQhAIJgAgh6MjowQgAAEIAABOwQQdDu+wBIIQADYA1d5AAAAgElEQVQCEIBAMAEEPRgdGSEAAQhAAAJ2CCDodnyBJRCAAAQgAIFgAgh6MDoyQgACEIAABOwQQNDt+AJLIAABCEAAAsEEEPRgdGSEAAQgAAEI2CGAoNvxBZZAAAIQgAAEggkg6MHoyAgBCEAAAhCwQwBBt+MLLIEABCAAAQgEE/g/Y48uFC1kKt8AAAAASUVORK5CYII=",
            "mix_doc": "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"
        }
    }
    return request_util.do_request(uri, data)


if __name__ == "__main__":
    print(datetime.datetime.now())
    my_card_type_id = "522981"
    my_email = "2759476460@legend.tech"
    my_mobile = "1880888808"
    my_mobile_code = "86"
    # card_apply_quick(my_card_type_id, my_email, my_mobile, my_mobile_code)
    # card_apply_basic()
    # activation(my_card_id)
    # my_card_id = card_result(my_card_type_id, my_email, my_mobile, my_mobile_code)["data"]["card_id"]
    # print(my_card_id)
    my_card_id = "6250235600000013562"
    # card_balance(my_card_id)
    # card_recharge(request_util.get_trade_id(), my_card_id)
    # merchant_balance("usdt")
    # card_bank_details(my_card_id)
    # card_transaction_record(my_card_id)
    # card_pay()
    # estimation_crypto()
    op_request_number = "20230523281021730328"
    # operation(my_card_id, op_request_number, 2)
    # operation_result(my_card_id, op_request_number, 2)
    card_list()
    # estimation_currency()
    # merchant_transactions("1684802615", "1684812615")
    # card_limit(my_card_id)
    # card_limit_result(my_card_id)
    # card_transactions("1684802615", "1684812615")
    # card_apply_quick_v2()
    # card_apply_basic_v2()
    # card_list_v2()
    # card_transaction_record_v2(my_card_id)
    # card_transactions_v2("1684802615", "1684812615")
    # buy_coin(my_card_id)
    # card_apply_quick_v3()
    binding_mc_trade_no = request_util.get_trade_id()
    # binding(binding_mc_trade_no)
    # binding_kyc(binding_mc_trade_no)
