package util;

import constant.OpenApiConstant;
import dto.ApiRequestParameters;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/**
 * @Desc http util
 * @Author Square
 * @Org www.legend.tech
 * @Date 2023/5/12 11:06
 **/
public class HttpUtil {
    private HttpClient client = new HttpClient();
    private PostMethod post;

    /**
     * post by json
     */
    public synchronized String postByJson(String url, ApiRequestParameters req) {

        HashMap<String, String> headers = req.getHeaders();
        HashMap<String, Object> parameters = req.getParameters();

        // params signature
        Map<String, String> signParams = getSignParams(headers, parameters);
        String sign = ApiSignUtils.sign(new HashMap<>(signParams), OpenApiConstant.CONFIG_PRI_KEY);
        headers.put(OpenApiConstant.HEADER_SIGNATURE, sign);

        System.out.println(">>> url: ");
        System.out.println(url);
        System.out.println(">>> params: ");
        System.out.println(JacksonUtil.toJsonString(parameters));
        System.out.println(">>> headers: ");
        System.out.println(JacksonUtil.toJsonString(headers));
        // test verify signature
//        verifySignature(headers, parameters);
        post = new PostMethod(url);
        if (parameters != null) {
            RequestEntity se = null;
            try {
                se = new StringRequestEntity(JacksonUtil.toJsonString(parameters), "application/json", "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            post.setRequestEntity(se);
        }

        try {
            // set headers
            for (String key : headers.keySet()) {
                post.setRequestHeader(key, headers.get(key));
            }
            client.executeMethod(post);
            InputStream response = post.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(response));
            String tempBf;
            StringBuffer re = new StringBuffer(100);
            while ((tempBf = br.readLine()) != null) {
                re.append(tempBf);
            }
            System.out.println(">>> response: ");
            System.out.println(re);
            return re.toString();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            post.releaseConnection();
        }
        return null;
    }

    private void verifySignature(HashMap<String, String> headers, HashMap<String, Object> params) {
        // get signature from header
        String signature = headers.get(OpenApiConstant.HEADER_SIGNATURE);
        // merchant public key
        String publicKey = OpenApiConstant.CONFIG_PUB_KEY;
        // build sign params
        Map<String, String> data = getSignParams(headers, params);
        boolean equals = ApiSignUtils.verify(signature, data, publicKey);
        System.out.println("verifySignature result：" + equals);
    }

    private HashMap<String, String> getSignParams(HashMap<String, String> headers, HashMap<String, Object> params) {
        HashMap<String, String> result = new HashMap<>();
        result.put(OpenApiConstant.HEADER_TIMESTAMP, headers.get(OpenApiConstant.HEADER_TIMESTAMP));
        String nonce = headers.get(OpenApiConstant.HEADER_NONCE);
        result.put(OpenApiConstant.HEADER_NONCE, nonce);
        String version = headers.get(OpenApiConstant.HEADER_VERSION);
        result.put(OpenApiConstant.HEADER_VERSION, version);
        String apiKey = headers.get(OpenApiConstant.HEADER_API_KEY);
        result.put(OpenApiConstant.HEADER_API_KEY, apiKey);
        String lang = headers.get(OpenApiConstant.HEADER_LANGUAGE);
        if (StringUtils.isNotBlank(lang)) {
            result.put(OpenApiConstant.HEADER_LANGUAGE, lang);
        }

        for (String key : params.keySet()) {
            result.put(key, params.get(key).toString());
        }
        return result;
    }
}
