package dto;

import constant.OpenApiConstant;
import util.JacksonUtil;

import java.util.HashMap;

/**
 * @Desc api request parameters
 * @Author Square
 * @Org www.legend.tech
 * @Date 2023/5/12 11:06
 **/
public class ApiRequestParameters {

    private HashMap<String, String> headers = new HashMap<>();
    private HashMap<String, Object> parameters = new HashMap<>();

    /**
     * add header
     *
     * @param name
     * @param value
     */
    public void addHeader(String name, String value) {
        headers.put(name, value);
    }

    /**
     * add parameter
     *
     * @param name
     * @param value
     */
    public void addParameter(String name, Object value) {
        parameters.put(name, value);
    }

    /**
     * add parameter
     *
     * @param jsonStr
     */
    public void addParameter(String jsonStr) {
        HashMap<String, Object> parse = JacksonUtil.parse(jsonStr, HashMap.class);
        for (String key : parse.keySet()) {
            addParameter(key, parse.get(key));
        }
    }

    public HashMap<String, String> getHeaders() {
        headers.put(OpenApiConstant.HEADER_TIMESTAMP, (System.currentTimeMillis() / 1000) + "");
        headers.put(OpenApiConstant.HEADER_NONCE, (System.currentTimeMillis() / 10000) + "");
        headers.put(OpenApiConstant.HEADER_API_KEY, OpenApiConstant.CONFIG_API_KEY);
        headers.put(OpenApiConstant.HEADER_VERSION, OpenApiConstant.CONFIG_VERSION);
        headers.put(OpenApiConstant.HEADER_LANGUAGE, OpenApiConstant.CONFIG_LANG);
        return headers;
    }

    public HashMap<String, Object> getParameters() {
        return parameters;
    }

}
