package demo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import constant.OpenApiConstant;
import constant.OpenApiUrlEnum;
import dto.ApiRequestParameters;
import util.HttpUtil;

/**
 * @Desc open api demo
 * @Author Square
 * @Org www.legend.tech
 * @Date 2023/5/12 11:06
 **/
public class OpenApiDemo {

    public static void main(String[] args) {
//        applyQuick();           // 2.1.1 Card Application (Express mode)
//        applyBase();            // 2.1.2 Card Application (Basic mode)
//        activation();           // 2.1.3 Activation
//        recharge();             // 2.1.4 Recharge
//        applyResult();          // 2.1.5 Inquiry Card Application Result
        balance();              // 2.1.6 Balance Inquiry
//        detail();               // 2.1.7 Inquiry on bank card detail
//        merchantBalance();      // 2.1.8 Inquiry on Merchant Account Balance
//        transactionRecord();    // 2.1.9 Inquiry on statement
//        cardPay();              // 2.1.10 Proceed Card Application Payment
//        estimationCrypto();     // 2.1.11 Estimate of amount of coin quantity needed for recharge
//        operation();            // 2.1.12 Card operation request
//        operationResult();      // 2.1.13 Enquiry on card operation request
//        cardList();             // 2.1.14 Retrive merchant card list
//        estimationCurrency();   // 2.1.15 Estimate the amount to receive
//        transactions();         // 2.1.16 Merchant transactions
//        cardLimit();            // 2.1.17 Modify Card Limit
//        limitResult();          // 2.1.18 Enquiry on card limit
//        cardTransactions();     // 2.1.19 Card transactions
//        applyQuickV2();         // 2.1.20 Card Application (Express mode)-v2
//        applyBaseV2();          // 2.1.21 Card Application (Basic mode)-v2
//        cardListV2();           // 2.1.22 Retrive merchant card list-v2
//        transactionRecordV2();  // 2.1.23 Inquiry on statement-v2
//        transactionV2();        // 2.1.24 Card transactions-v2
//        cardBuyCoin();          // 2.1.25 Purchase Crypto Coin
    }

    /**
     * 2.1.1 Card Application (Express mode)
     */
    public static void applyQuick() {
        String paramJsonStr = "{\n" +
                " \"card_type_id\": 88990001,\n" +
                " \"email\": \"example@gmail.com\",\n" +
                " \"first_name\": \"pan\",\n" +
                " \"last_name\": \"gao\",\n" +
                " \"mobile\": 1238888888,\n" +
                " \"mobile_code\": 86\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(211).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.2 Card Application (Basic mode)
     */
    public static void applyBase() {
        String paramJsonStr = "{\n" +
                " \"address\": \"maizidianjie28hao\",\n" +
                " \"back_doc\": \"\",\n" +
                " \"birthday\": \"1990-01-01\",\n" +
                " \"card_type_id\": \"50000001\",\n" +
                " \"city\": \"beijing\",\n" +
                " \"country_code\": \"CHN\",\n" +
                " \"doc_no\": 12345678,\n" +
                " \"doc_type\": 1,\n" +
                " \"email\": \"square_test@gmail.com\",\n" +
                " \"emergency_contact\": \"John\",\n" +
                " \"first_name\": \"pan\",\n" +
                " \"front_doc\": \"\",\n" +
                " \"gender\": 1,\n" +
                " \"last_name\": \"gao\",\n" +
                " \"mix_doc\": \"\",\n" +
                " \"mobile\": \"1348888888\",\n" +
                " \"mobile_code\": \"86\",\n" +
                " \"nationality_code\": \"1\",\n" +
                " \"sign_img\": \"\",\n" +
                " \"state\": \"beijing\",\n" +
                " \"user_ip\": \"40.77.166.66\",\n" +
                " \"zip_code\": \"100100\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);
        params.addParameter("sign_img", OpenApiConstant.IMG);
        params.addParameter("front_doc", OpenApiConstant.IMG);
        params.addParameter("mix_doc", OpenApiConstant.IMG);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(212).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.3 Activation
     */
    public static void activation() {
        String paramJsonStr = "{\"card_id\": \"11839637889900014528\"}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(213).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.4 Recharge
     */
    public static void recharge() {
        String paramJsonStr = "{\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"mc_trade_no\": \"48d2741747a4493223feb22\",\n" +
                " \"pay_coin\": \"usdt\",\n" +
                " \"recharge_amount\": \"188.88\",\n" +
                " \"remark\": \"Any remark\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(214).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.5 Inquiry Card Application Result
     */
    public static void applyResult() {
        String paramJsonStr = "{" +
                "\"card_type_id\": \"88990001\",\n" +
                " \"email\": \"square@legend.tech\",\n" +
                " \"mobile\": \"1522159765\",\n" +
                " \"mobile_code\": \"86\"" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(215).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.6 Balance Inquiry
     */
    public static void balance() {
        String paramJsonStr = "{\"card_id\": \"11839637889900014528\"}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(216).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.7 Inquiry on bank card detail
     */
    public static void detail() {
        String paramJsonStr = "{\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"pub_key\": \"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC37by7wUaaPgE0ljdw3F/8OX6qzcX6rKzcmCtn2cKHbuZ+ynPGgFZX5lqlEEKdXI8sBEuqtxU+0G+eRlmTtSAqqytF0K0rM50mKGfF2hPw//Z4ajKymsRghdiUPXJ6AxN8oyY15l1uMZcD0Ru0/OQp7VdSLNtZmKDOMhm9GeodAwIDAQAB\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(217).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.8 Inquiry on Merchant Account Balance
     */
    public static void merchantBalance() {
        String paramJsonStr = "{\"coin\": \"usdt\"}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(218).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.9 Inquiry on statement
     */
    public static void transactionRecord() {
        String paramJsonStr = "{\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"end_time\": \"052023\",\n" +
                " \"start_time\": \"042023\" }";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(219).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.10 Proceed Card Application Payment
     */
    public static void cardPay() {
        String paramJsonStr = "{\n" +
                "\"card_type_id\": 88990001,\n" +
                " \"email\": \"square@legend.tech\",\n" +
                " \"mobile\": \"1522159765\",\n" +
                " \"mobile_code\": \"86\"" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2110).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.11 Estimate of amount of coin quantity needed for recharge
     */
    public static void estimationCrypto() {
        String paramJsonStr = "{ \n" +
                " \"card_type_id\": \"88990001\",\n" +
                " \"pay_coin\": \"usdt\",\n" +
                " \"recharge_amount\": \"188\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2111).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.12 Card operation request
     */
    public static void operation() {
        String paramJsonStr = "{ \n" +
                "\"card_id\":\"11839637889900014528\",\n" +
                "\"request_number\":\"48d2741747a449b2968a91e2523feb22\",\n" +
                "\"type\":2\n" +
                "} }";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2112).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.13 Enquiry on card operation request
     */
    public static void operationResult() {
        String paramJsonStr = "{ \n" +
                "\"card_id\":\"11839637889900014528\",\n" +
                "\"request_number\":\"48d2741747a449b2968a91e2523feb22\",\n" +
                "\"type\":2\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2113).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.14 Retrive merchant card list
     */
    public static void cardList() {
        ApiRequestParameters params = new ApiRequestParameters();

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2114).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.15 Estimate the amount to receive
     */
    public static void estimationCurrency() {
        String paramJsonStr = "{\n" +
                " \"card_type_id\": \"88990001\",\n" +
                " \"coin_amount\": \"188\",\n" +
                " \"pay_coin\": \"usdt\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2115).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.16 Merchant transactions
     */
    public static void transactions() {
        String paramJsonStr = "{\n" +
                " \"coin\": \"usdt\",\n" +
                " \"end_time\": \"1684207607\",\n" +
                " \"page\": \"1\",\n" +
                " \"size\": \"50\",\n" +
                " \"start_time\": \"1681615607\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2116).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.17 Modify Card Limit
     */
    public static void cardLimit() {
        String paramJsonStr = "{\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"max_amount_daily\": \"8888\",\n" +
                " \"max_amount_monthly\": \"88888\",\n" +
                " \"max_amount_single\": \"888\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2117).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.18 Enquiry on card limit
     */
    public static void limitResult() {
        String paramJsonStr = "{\"card_id\": \"11839637889900014528\"}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2118).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.19 Card transactions
     */
    public static void cardTransactions() {
        String paramJsonStr = "{\n" +
                " \"end_time\": \"1684207607\",\n" +
                " \"page\": \"1\",\n" +
                " \"size\": \"50\",\n" +
                " \"start_time\": \"1681615607\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2119).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.20 Card Application (Express mode)-v2
     */
    public static void applyQuickV2() {
        String paramJsonStr = "{\n" +
                " \"card_type_id\": 88990001,\n" +
                " \"email\": \"square1@gmail.com\",\n" +
                " \"first_name\": \"big\",\n" +
                " \"last_name\": \"fang\",\n" +
                " \"mobile\": 18833338888,\n" +
                " \"mobile_code\": 86,\n" +
                " \"first_recharge_amount\": \"10\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2120).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.21 Card Application (Basic mode)-v2
     */
    public static void applyBaseV2() {
        String paramJsonStr = "{\n" +
                " \"address\": \"maizidianjie28hao\",\n" +
                " \"back_doc\": \"\",\n" +
                " \"birthday\": \"1990-01-01\",\n" +
                " \"card_type_id\": \"50000001\",\n" +
                " \"city\": \"beijing\",\n" +
                " \"country_code\": \"CHN\",\n" +
                " \"doc_no\": 12345678,\n" +
                " \"doc_type\": 1,\n" +
                " \"email\": \"square2@gmail.com\",\n" +
                " \"emergency_contact\": \"small\",\n" +
                " \"first_name\": \"fang\",\n" +
                " \"first_recharge_amount\": \"188\",\n" +
                " \"front_doc\": \"\",\n" +
                " \"gender\": 1,\n" +
                " \"last_name\": \"pig\",\n" +
                " \"mix_doc\": \"\",\n" +
                " \"mobile\": \"18822228888\",\n" +
                " \"mobile_code\": \"86\",\n" +
                " \"nationality_code\": \"1\",\n" +
                " \"sign_img\": \"\",\n" +
                " \"state\": \"beijing\",\n" +
                " \"user_ip\": \"40.77.166.66\",\n" +
                " \"zip_code\": \"100100\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);
        params.addParameter("sign_img", OpenApiConstant.IMG);
        params.addParameter("front_doc", OpenApiConstant.IMG);
        params.addParameter("mix_doc", OpenApiConstant.IMG);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2121).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.22 Retrive merchant card list-v2
     */
    public static void cardListV2() {
        ApiRequestParameters params = new ApiRequestParameters();

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2122).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.23 Inquiry on statement-v2
     */
    public static void transactionRecordV2() {
        String paramJsonStr = "{\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"end_time\": \"052023\",\n" +
                " \"start_time\": \"042023\" }";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2123).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.24 Card transactions-v2
     */
    public static void transactionV2() {
        String paramJsonStr = "{\n" +
                " \"end_time\": \"1684207607\",\n" +
                " \"page\": \"1\",\n" +
                " \"size\": \"50\",\n" +
                " \"start_time\": \"1681615607\"\n" +
                "}";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2124).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 2.1.25 Purchase Crypto Coin
     */
    public static void cardBuyCoin() {
        String paramJsonStr = "{\n" +
                " \"card_currency\": \"usd\",\n" +
                " \"card_id\": \"11839637889900014528\",\n" +
                " \"currency_amount\": \"100\",\n" +
                " \"mc_trade_no\": \"48d2741747a4493223feb22\",\n" +
                " \"remark\": \"Remark\" }";
        ApiRequestParameters params = new ApiRequestParameters();
        params.addParameter(paramJsonStr);

        String url = OpenApiConstant.CONFIG_HOST + OpenApiUrlEnum.fromCode(2125).getUrl();
        String response = new HttpUtil().postByJson(url, params);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
