package constant;

import java.util.Arrays;
import java.util.Optional;

/**
 * @Desc open api url enum
 * @Author Square
 * @Org www.legend.tech
 * @Date 2023/5/15 11:06
 **/
public enum OpenApiUrlEnum {

    /**
     * 2.1.1 Card Application (Express mode)
     */
    URL_CARD_APPLICATION_EXPRESS(211, "Card Application (Express mode)", "/openapi/card/apply/quick"),

    /**
     * 2.1.2 Card Application (Basic mode)
     */
    URL_CARD_APPLICATION_BASIC(212, "Card Application (Basic mode)", "/openapi/card/apply"),

    /**
     * 2.1.3 Activation
     */
    URL_ACTIVATION(213, "Activation", "/openapi/card/active"),

    /**
     * 2.1.4 Recharge
     */
    URL_RECHARGE(214, "Recharge", "/openapi/card/recharge"),

    /**
     * 2.1.5 Inquiry Card Application Result
     */
    URL_APPLY_RESULT(215, "Inquiry Card Application Result", "/openapi/card/apply/result"),

    /**
     * 2.1.6 Balance Inquiry
     */
    URL_BALANCE_INQUIRY(216, "Balance Inquiry", "/openapi/card/balance"),

    /**
     * 2.1.7 Inquiry on bank card detail
     */
    URL_BANK_DETAILS(217, "Inquiry on bank card detail", "/openapi/card/bank/details"),

    /**
     * 2.1.8 Inquiry on Merchant Account Balance
     */
    URL_MERCHANT_BALANCE(218, "Inquiry on Merchant Account Balance", "/openapi/card/merchant/balance"),

    /**
     * 2.1.9 Inquiry on statement
     */
    URL_TRANSACTION_RECORD(219, "Inquiry on Merchant Account Balance", "/openapi/card/transaction/record"),

    /**
     * 2.1.10 Proceed Card Application Payment
     */
    URL_PAY(2110, "Proceed Card Application Payment", "/openapi/card/pay"),

    /**
     * 2.1.11 Estimate of amount of coin quantity needed for recharge
     */
    URL_ESTIMATION_CRYPTO(2111, "Estimate of amount of coin quantity needed for recharge", "/openapi/card/estimation/crypto"),

    /**
     * 2.1.12 Card operation request
     */
    URL_OPERATION(2112, "Card operation request", "/openapi/card/operation"),

    /**
     * 2.1.13 Enquiry on card operation request
     */
    URL_OPERATION_RESULT(2113, "Enquiry on card operation request", "/openapi/card/operation/result"),

    /**
     * 2.1.14 Retrive merchant card list
     */
    URL_LIST(2114, "Retrive merchant card list", "/openapi/card/list"),

    /**
     * 2.1.15 Estimate the amount to receive
     */
    URL_ESTIMATION_CURRENCY(2115, "Estimate the amount to receive", "/openapi/card/estimation/currency"),

    /**
     * 2.1.16 Merchant transactions
     */
    URL_MERCHANT_TRANSACTIONS(2116, "Merchant transactions", "/openapi/card/merchant/transactions"),

    /**
     * 2.1.17 Modify Card Limit
     */
    URL_LIMIT(2117, "Modify Card Limit", "/openapi/card/limit"),

    /**
     * 2.1.18 Enquiry on card limit
     */
    URL_LIMIT_RESULT(2118, "Enquiry on card limit", "/openapi/card/limit/result"),

    /**
     * 2.1.19 Card transactions
     */
    URL_TRANSACTIONS(2119, "Card transactions", "/openapi/card/transactions"),

    /**
     * 2.1.20 Card Application (Express mode)-v2
     */
    URL_V2_APPLY_QUICK(2120, "Card Application (Express mode)-v2", "/v2/openapi/card/apply/quick"),

    /**
     * 2.1.21 Card Application (Basic mode)-v2
     */
    URL_V2_APPLY(2121, "Card Application (Basic mode)-v2", "/v2/openapi/card/apply"),

    /**
     * 2.1.22 Retrive merchant card list-v2
     */
    URL_V2_LIST(2122, "Retrive merchant card list-v2", "/openapi/card/list"),

    /**
     * 2.1.23 Inquiry on statement-v2
     */
    URL_V2_TRANSACTION_RECORD(2123, "Inquiry on statement-v2", "/v2/openapi/card/transaction/record"),

    /**
     * 2.1.24 Card transactions-v2
     */
    URL_V2_TRANSACTION(2124, "Card transactions-v2", "/v2/openapi/card/transactions"),

    /**
     * 2.1.25 Purchase Crypto Coin
     */
    URL_V2_BUY_COIN(2125, "Purchase Crypto Coin", "/openapi/card/buy/coin"),

    ;

    final Integer code;
    final String msg;
    final String url;

    OpenApiUrlEnum(Integer code, String msg, String url) {
        this.code = code;
        this.msg = msg;
        this.url = url;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getUrl() {
        return url;
    }

    public static OpenApiUrlEnum fromCode(int code) {
        Optional<OpenApiUrlEnum> list = Arrays.stream(values())
                .filter(o -> o.getCode().equals(code))
                .findFirst();
        return list.orElse(null);
    }
}
